/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.UnproxyableResolutionException;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.context.AbstractContext;
import org.apache.webbeans.context.creational.CreationalContextFactory;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorHandler;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InvocationContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalScopedBeanInterceptorHandler
extends InterceptorHandler {
    private static final long serialVersionUID = 1L;
    private static final String FINALIZE = "finalize".intern();
    private CopyOnWriteArrayList<Integer> cachedInterceptedMethods = new CopyOnWriteArrayList();

    public NormalScopedBeanInterceptorHandler(OwbBean<?> bean, CreationalContext<?> creationalContext) {
        super(bean);
        this.initiateBeanBag(bean, creationalContext);
    }

    private void initiateBeanBag(OwbBean<Object> bean, CreationalContext<Object> creationalContext) {
        try {
            Context webbeansContext = this.getBeanManager().getContext(bean.getScope());
            if (webbeansContext instanceof AbstractContext) {
                AbstractContext owbContext = (AbstractContext)webbeansContext;
                owbContext.initContextualBag(bean, creationalContext);
            }
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
    }

    @Override
    protected boolean isNotInterceptedOrDecoratedMethod(Method method) {
        int currentHash = method.hashCode();
        return this.cachedInterceptedMethods.contains(currentHash);
    }

    @Override
    protected void setNotInterceptedOrDecoratedMethod(Method method) {
        Integer hashCode = method.hashCode();
        if (!this.cachedInterceptedMethods.contains(hashCode)) {
            this.cachedInterceptedMethods.add(hashCode);
        }
    }

    @Override
    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments) throws Exception {
        if (method.getName() == FINALIZE && method.getParameterTypes().length == 0 && method.getReturnType() == Void.TYPE) {
            return null;
        }
        Object webbeansInstance = this.getContextualInstance();
        return super.invoke(webbeansInstance, method, proceed, arguments, (CreationalContextImpl)this.getContextualCreationalContext());
    }

    @Override
    protected Object callAroundInvokes(Method proceed, Object[] arguments, List<InterceptorData> stack) throws Exception {
        InvocationContextImpl impl = new InvocationContextImpl(this.webBeansContext, this.bean, this.getContextualInstance(), proceed, arguments, stack, InterceptorType.AROUND_INVOKE);
        impl.setCreationalContext(this.getContextualCreationalContext());
        return impl.proceed();
    }

    protected Object getContextualInstance() {
        Context webbeansContext = this.getBeanManager().getContext(this.bean.getScope());
        Object webbeansInstance = webbeansContext.get(this.bean);
        if (webbeansInstance != null) {
            return webbeansInstance;
        }
        webbeansInstance = webbeansContext.get(this.bean, this.getContextualCreationalContext());
        if (webbeansInstance == null) {
            throw new UnproxyableResolutionException("Cannot find a contextual instance of bean " + this.bean.toString());
        }
        return webbeansInstance;
    }

    protected CreationalContext<Object> getContextualCreationalContext() {
        AbstractContext owbContext;
        CreationalContext creationalContext = null;
        OwbBean contextual = this.bean;
        Context webbeansContext = this.getBeanManager().getContext(this.bean.getScope());
        CreationalContextFactory contextFactory = this.bean.getWebBeansContext().getCreationalContextFactory();
        if (webbeansContext instanceof AbstractContext && (creationalContext = (owbContext = (AbstractContext)webbeansContext).getCreationalContext(contextual)) == null) {
            creationalContext = contextFactory.getCreationalContext(contextual);
            owbContext.initContextualBag(this.bean, creationalContext);
        }
        if (creationalContext == null) {
            creationalContext = contextFactory.getCreationalContext(contextual);
        }
        return creationalContext;
    }
}

