/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee.jpa;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.openejb.jee.JAXBContextFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JpaJaxbUtil {
    public static <T> String marshal(Class<T> type, Object object) throws JAXBException {
        JAXBContext ctx2 = JAXBContextFactory.newInstance(type);
        Marshaller marshaller = ctx2.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal(object, baos);
        return new String(baos.toByteArray());
    }

    public static <T> void marshal(Class<T> type, Object object, OutputStream out) throws JAXBException {
        JAXBContext ctx2 = JAXBContextFactory.newInstance(type);
        Marshaller marshaller = ctx2.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        marshaller.marshal(object, out);
    }

    public static <T> Object unmarshal(Class<T> type, InputStream in) throws ParserConfigurationException, SAXException, JAXBException {
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        JAXBContext ctx = JAXBContextFactory.newInstance(type);
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            @Override
            public boolean handleEvent(ValidationEvent validationEvent) {
                System.out.println(validationEvent);
                return false;
            }
        });
        return unmarshaller.unmarshal(inputSource);
    }
}

