/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.MethodIntf;
import org.apache.openejb.jee.MethodParams;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="methodType", propOrder={"descriptions", "ejbName", "methodIntf", "methodName", "methodParams"})
public class Method {
    @XmlElement(name="ejb-name", required=true)
    protected String ejbName;
    @XmlTransient
    protected String className;
    @XmlElement(name="method-intf")
    protected MethodIntf methodIntf;
    @XmlElement(name="method-name", required=true)
    protected String methodName;
    @XmlElement(name="method-params")
    protected MethodParams methodParams;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;
    @XmlTransient
    protected TextMap description = new TextMap();

    public Method(String ejbName, java.lang.reflect.Method method) {
        this.ejbName = ejbName;
        this.methodName = method.getName();
        this.className = method.getDeclaringClass().getName();
        MethodParams methodParams = new MethodParams();
        for (Class<?> type : method.getParameterTypes()) {
            methodParams.getMethodParam().add(type.getName());
        }
        this.methodParams = methodParams;
    }

    public Method(String ejbName, String methodName, String ... parameters) {
        this(ejbName, (String)null, methodName, parameters);
    }

    public Method(String ejbName, String className, String methodName, String ... parameters) {
        this.ejbName = ejbName;
        this.methodName = methodName;
        this.className = className;
        if (parameters.length > 0) {
            MethodParams params = new MethodParams();
            for (String paramName : parameters) {
                params.getMethodParam().add(paramName);
            }
            this.methodParams = params;
        }
    }

    public Method() {
    }

    public Method(String ejbName, String methodName) {
        this(ejbName, (String)null, methodName);
    }

    public Method(String ejbName, String className, String methodName) {
        this.ejbName = ejbName;
        this.methodName = methodName;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String value) {
        this.ejbName = value;
    }

    public MethodIntf getMethodIntf() {
        return this.methodIntf;
    }

    public void setMethodIntf(MethodIntf value) {
        this.methodIntf = value;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String value) {
        this.methodName = value;
    }

    public MethodParams getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(MethodParams value) {
        this.methodParams = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }
}

