/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.InterceptorOrder;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="interceptor-bindingType", propOrder={"description", "ejbName", "interceptorClass", "interceptorOrder", "excludeDefaultInterceptors", "excludeClassInterceptors", "method"})
public class InterceptorBinding {
    @XmlElement(required=true)
    protected List<Text> description;
    @XmlElement(name="ejb-name", required=true)
    protected String ejbName;
    @XmlElement(name="interceptor-class", required=true)
    protected List<String> interceptorClass;
    @XmlElement(name="interceptor-order")
    protected InterceptorOrder interceptorOrder;
    @XmlElement(name="exclude-default-interceptors")
    protected boolean excludeDefaultInterceptors;
    @XmlElement(name="exclude-class-interceptors")
    protected boolean excludeClassInterceptors;
    protected NamedMethod method;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public InterceptorBinding() {
    }

    public InterceptorBinding(EnterpriseBean bean, Interceptor ... interceptors) {
        this(bean.getEjbName(), interceptors);
    }

    public InterceptorBinding(String ejbName, Interceptor ... interceptors) {
        this.ejbName = ejbName;
        List<String> interceptorClasses = this.getInterceptorClass();
        for (Interceptor interceptor : interceptors) {
            interceptorClasses.add(interceptor.getInterceptorClass());
        }
    }

    public InterceptorBinding(String ejbName, String ... interceptorClasses) {
        this.ejbName = ejbName;
        this.getInterceptorClass().addAll(Arrays.asList(interceptorClasses));
    }

    public InterceptorBinding(String ejbName) {
        this.ejbName = ejbName;
    }

    public List<Text> getDescription() {
        if (this.description == null) {
            this.description = new ArrayList<Text>();
        }
        return this.description;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String value) {
        this.ejbName = value;
    }

    public List<String> getInterceptorClass() {
        if (this.interceptorClass == null) {
            this.interceptorClass = new ArrayList<String>();
        }
        return this.interceptorClass;
    }

    public InterceptorOrder getInterceptorOrder() {
        return this.interceptorOrder;
    }

    public InterceptorOrder setInterceptorOrder(InterceptorOrder value) {
        this.interceptorOrder = value;
        return value;
    }

    public boolean getExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    public void setExcludeDefaultInterceptors(boolean value) {
        this.excludeDefaultInterceptors = value;
    }

    public boolean getExcludeClassInterceptors() {
        return this.excludeClassInterceptors;
    }

    public void setExcludeClassInterceptors(boolean value) {
        this.excludeClassInterceptors = value;
    }

    public NamedMethod getMethod() {
        return this.method;
    }

    public void setMethod(NamedMethod value) {
        this.method = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }
}

