/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
    * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.openejb.sxc;

import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.TldTaglib$JAXB;
import org.apache.openejb.loader.IO;
import org.metatype.sxc.util.XoXMLStreamReaderImpl;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.stream.StreamResult;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

/**
 * @version $Rev$ $Date$
 */
public class TldTaglibXml {

    public static TldTaglib unmarshal(InputStream inputStream) throws Exception {
        return Sxc.unmarshalJavaee(new TldTaglib$JAXB(), inputStream);
    }

    public static TldTaglib unmarshal(URL url) throws Exception {
        final InputStream inputStream = IO.read(url);
        try {
            final XMLStreamReader filter = new TaglibNamespaceFilter(Sxc.prepareReader(inputStream));
            return Sxc.unmarhsal(new TldTaglib$JAXB(), new XoXMLStreamReaderImpl(filter));
        } finally {
            IO.close(inputStream);
        }
    }

    public static void marshal(TldTaglib taglib, OutputStream outputStream) throws Exception {
        Sxc.marshal(new TldTaglib$JAXB(), taglib, new StreamResult(outputStream));
    }

    public static class TaglibNamespaceFilter extends StreamReaderDelegate {
        public TaglibNamespaceFilter(final XMLStreamReader xmlStreamReader) {
            super(xmlStreamReader);
        }

        @Override
        public String getLocalName() {
            return fixLocalName(super.getLocalName());
        }

        protected String fixLocalName(final String localName) {
            if (localName.equals("tlibversion")) {
                return "tlib-version";
            } else if (localName.equals("jspversion")) {
                return "jsp-version";
            } else if (localName.equals("shortname")) {
                return "short-name";
            } else if (localName.equals("tagclass")) {
                return "tag-class";
            } else if (localName.equals("teiclass")) {
                return "tei-class";
            } else if (localName.equals("bodycontent")) {
                return "body-content";
            } else if (localName.equals("jspversion")) {
                return "jsp-version";
            } else if (localName.equals("info")) {
                return "description";
            }
            return localName;
        }
    }
}
