/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.DefaultedThreadLocal;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.JNDIContext;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.ServerMetaData;

public class EJBObjectProxyHandle
implements Externalizable {
    private static final long serialVersionUID = -8325446328982364608L;
    public static final ThreadLocal<Resolver> resolver = new DefaultedThreadLocal<ClientSideResovler>(new ClientSideResovler());
    private transient EJBObjectHandler handler;
    private transient ProtocolMetaData metaData;

    public EJBObjectProxyHandle() {
    }

    public EJBObjectProxyHandle(EJBObjectHandler handler) {
        this.handler = handler;
    }

    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        this.handler.client.setMetaData(this.metaData);
        this.handler.client.writeExternal(out);
        this.handler.ejb.setMetaData(this.metaData);
        this.handler.ejb.writeExternal(out);
        this.handler.server.setMetaData(this.metaData);
        this.handler.server.writeExternal(out);
        out.writeObject(this.handler.primaryKey);
        out.writeObject(this.handler.authenticationInfo);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        ClientMetaData client = new ClientMetaData();
        EJBMetaDataImpl ejb = new EJBMetaDataImpl();
        ServerMetaData server = new ServerMetaData();
        client.setMetaData(this.metaData);
        ejb.setMetaData(this.metaData);
        server.setMetaData(this.metaData);
        client.readExternal(in);
        ejb.readExternal(in);
        server.readExternal(in);
        Object primaryKey = in.readObject();
        JNDIContext.AuthenticationInfo authenticationInfo = (JNDIContext.AuthenticationInfo)JNDIContext.AuthenticationInfo.class.cast(in.readObject());
        this.handler = EJBObjectHandler.createEJBObjectHandler(ejb, server, client, primaryKey, authenticationInfo);
    }

    private Object readResolve() throws ObjectStreamException {
        return resolver.get().resolve(this.handler);
    }

    public static class ClientSideResovler
    implements Resolver {
        @Override
        public Object resolve(EJBObjectHandler handler) {
            return handler.createEJBObjectProxy();
        }
    }

    public static interface Resolver {
        public Object resolve(EJBObjectHandler var1);
    }
}

