/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;
import org.apache.openejb.client.ConnectionPoolTimeoutException;
import org.apache.openejb.client.KeepAliveStyle;

public class SocketConnectionFactory
implements ConnectionFactory {
    private KeepAliveStyle keepAliveStyle = KeepAliveStyle.PING;
    private static Map<URI, Pool> connections = new ConcurrentHashMap<URI, Pool>();
    private int size = this.getSize();
    private long timeout = this.getTimeout();

    private long getTimeout() {
        Properties p = System.getProperties();
        long timeout = SocketConnectionFactory.getLong(p, "openejb.client.connectionpool.timeout", this.timeout);
        timeout = SocketConnectionFactory.getLong(p, "openejb.client.connection.pool.timeout", timeout);
        return timeout;
    }

    private int getSize() {
        Properties p = System.getProperties();
        int size = SocketConnectionFactory.getInt(p, "openejb.client.connectionpool.size", this.size);
        size = SocketConnectionFactory.getInt(p, "openejb.client.connection.pool.size", size);
        return size;
    }

    public static int getInt(Properties p, String property, int defaultValue) {
        String value = p.getProperty(property);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(Properties p, String property, long defaultValue) {
        String value = p.getProperty(property);
        try {
            if (value != null) {
                return Long.parseLong(value);
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Connection getConnection(URI uri) throws IOException {
        Pool pool = this.getPool(uri);
        SocketConnection conn = pool.get();
        if (conn == null) {
            try {
                conn = new SocketConnection(uri, pool);
                conn.open(uri);
            }
            catch (IOException e) {
                pool.put(null);
                throw e;
            }
        }
        try {
            conn.lock.tryLock(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            pool.put(conn);
            throw new IOException("Connection busy");
        }
        OutputStream ouputStream = conn.getOuputStream();
        if (conn.socket.isClosed()) {
            pool.put(null);
            return this.getConnection(uri);
        }
        try {
            ouputStream.write(this.getKeepAliveStyle().ordinal());
            switch (this.getKeepAliveStyle()) {
                case PING_PING: {
                    ouputStream.flush();
                    ouputStream.write(this.getKeepAliveStyle().ordinal());
                    ouputStream.flush();
                    break;
                }
                case PING_PONG: {
                    ouputStream.flush();
                    conn.getInputStream().read();
                }
            }
        }
        catch (IOException e) {
            pool.put(null);
            throw e;
        }
        return conn;
    }

    private Pool getPool(URI uri) {
        Pool pool = connections.get(uri);
        if (pool == null) {
            pool = new Pool(uri, this.getSize(), this.getTimeout());
            connections.put(uri, pool);
        }
        return pool;
    }

    public KeepAliveStyle getKeepAliveStyle() {
        String property = System.getProperty("openejb.client.keepalive");
        if (property != null) {
            property = property.toUpperCase();
            return KeepAliveStyle.valueOf(property);
        }
        return this.keepAliveStyle;
    }

    private static class Pool {
        private final Semaphore semaphore;
        private final Stack<SocketConnection> pool;
        private final long timeout;
        private final TimeUnit timeUnit;
        private final int size;
        private final URI uri;

        private Pool(URI uri, int size, long timeout) {
            this.uri = uri;
            this.size = size;
            this.semaphore = new Semaphore(size);
            this.pool = new Stack();
            this.timeout = timeout;
            this.timeUnit = TimeUnit.MILLISECONDS;
            Object[] objects = new Object[size];
            for (int i = 0; i < objects.length; ++i) {
                this.pool.push(null);
            }
        }

        public SocketConnection get() throws IOException {
            try {
                if (this.semaphore.tryAcquire(this.timeout, this.timeUnit)) {
                    return this.pool.pop();
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            throw new ConnectionPoolTimeoutException("No connections available in pool (size " + this.size + ").  Waited for " + this.timeout + " seconds for a connection.");
        }

        public void put(SocketConnection connection) {
            this.pool.push(connection);
            this.semaphore.release();
        }

        public String toString() {
            return "Pool{size=" + this.size + ", available=" + this.semaphore.availablePermits() + ", uri=" + this.uri + '}';
        }
    }

    public class Output
    extends FilterOutputStream {
        public Output(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
            this.flush();
        }
    }

    public class Input
    extends FilterInputStream {
        public Input(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }

    class SocketConnection
    implements Connection {
        private Socket socket = null;
        private final URI uri;
        private boolean discarded;
        private final Pool pool;
        private final Lock lock = new ReentrantLock();
        private OutputStream out;
        private BufferedInputStream in;

        public SocketConnection(URI uri, Pool pool) {
            this.uri = uri;
            this.pool = pool;
        }

        protected void open(URI uri) throws IOException {
            try {
                if (uri.getScheme().equalsIgnoreCase("ejbds")) {
                    SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(uri.getHost(), uri.getPort());
                    String[] enabledCipherSuites = new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"};
                    sslSocket.setEnabledCipherSuites(enabledCipherSuites);
                    this.socket = sslSocket;
                } else {
                    this.socket = new Socket(uri.getHost(), uri.getPort());
                }
                this.socket.setTcpNoDelay(true);
            }
            catch (ConnectException e) {
                throw new ConnectException("Cannot connect to server '" + uri.toString() + "'.  Check that the server is started and that the specified serverURL is correct.");
            }
            catch (IOException e) {
                throw new IOException("Cannot connect to server: '" + uri.toString() + "'.  Exception: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (SecurityException e) {
                throw new IOException("Cannot access server: '" + uri.toString() + "' due to security restrictions in the current VM: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot  connect to server: '" + uri.toString() + "' due to an unkown exception in the OpenEJB client: " + e.getClass().getName() + " : " + e.getMessage());
            }
        }

        public void discard() {
            this.pool.put(null);
            this.discarded = true;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public URI getURI() {
            return this.uri;
        }

        public void close() throws IOException {
            if (this.discarded) {
                return;
            }
            this.pool.put(this);
            this.lock.unlock();
        }

        public InputStream getInputStream() throws IOException {
            try {
                if (this.in == null) {
                    this.in = new BufferedInputStream(this.socket.getInputStream());
                }
                return new Input(this.in);
            }
            catch (StreamCorruptedException e) {
                throw new IOException("Cannot open input stream to server, the stream has been corrupted: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (IOException e) {
                throw new IOException("Cannot open input stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
        }

        public OutputStream getOuputStream() throws IOException {
            try {
                if (this.out == null) {
                    this.out = new BufferedOutputStream(this.socket.getOutputStream());
                }
                return new Output(this.out);
            }
            catch (IOException e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
        }
    }
}

