/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package javax.resource.spi;

import java.io.Serializable;

/**
 * Runtime transaction support level available fom a ManagedConnectionFactory
 * @since 1.6
 * @version $Rev: 806898 $ $Date: 2009-08-22 18:11:25 -0400 (Sat, 22 Aug 2009) $
 */
public interface TransactionSupport extends Serializable {

    TransactionSupportLevel getTransactionSupport();

    enum TransactionSupportLevel {

        NoTransaction, LocalTransaction, XATransaction

    }
    
}
