/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.cdi;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.http.HttpSession;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.cdi.SessionContextBackedByHttpSession;
import org.apache.webbeans.context.creational.BeanInstanceBag;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;

public class SessionNormalScopeBeanHandler
extends NormalScopedBeanInterceptorHandler {
    private static final Field BAG_INSTANCE;
    private static final ThreadLocal<Map<Bean<?>, UpdateInfo>> OBJECTS;

    public SessionNormalScopeBeanHandler(BeanManager beanManager, Bean<?> bean) {
        super(beanManager, bean);
    }

    public Object get() {
        Object webbeansInstance = this.getContextualInstance();
        Map<Bean<?>, UpdateInfo> beanUpdateInfoMap = OBJECTS.get();
        if (!beanUpdateInfoMap.containsKey(this.bean)) {
            beanUpdateInfoMap.put(this.bean, new UpdateInfo(this.bean, this.getBeanManager(), webbeansInstance));
        }
        return webbeansInstance;
    }

    static {
        try {
            BAG_INSTANCE = BeanInstanceBag.class.getDeclaredField("beanInstance");
            BAG_INSTANCE.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new TomEERuntimeException(e);
        }
        OBJECTS = new ThreadLocal<Map<Bean<?>, UpdateInfo>>(){

            @Override
            protected Map<Bean<?>, UpdateInfo> initialValue() {
                CdiAppContextsService.pushRequestReleasable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Map values = (Map)OBJECTS.get();
                        for (UpdateInfo o : values.values()) {
                            o.updateBean();
                        }
                        values.clear();
                        OBJECTS.remove();
                    }
                });
                return new HashMap();
            }
        };
    }

    protected static class UpdateInfo {
        private Bean<?> bean;
        private BeanManager bm;
        private Object value;

        protected UpdateInfo(Bean<?> bean, BeanManager bm, Object value) {
            this.bean = bean;
            this.bm = bm;
            this.value = value;
        }

        protected void updateBean() {
            HttpSession session = this.session();
            if (session == null) {
                return;
            }
            String key = SessionContextBackedByHttpSession.key(this.bean);
            BeanInstanceBag bag = (BeanInstanceBag)BeanInstanceBag.class.cast(session.getAttribute(key));
            if (bag != null) {
                try {
                    BAG_INSTANCE.set(bag, this.value);
                }
                catch (IllegalAccessException e) {
                    throw new TomEERuntimeException(e);
                }
                session.setAttribute(key, (Object)bag);
            }
        }

        private HttpSession session() {
            Context context = this.bm.getContext(SessionScoped.class);
            if (!SessionContextBackedByHttpSession.class.isInstance(context)) {
                return null;
            }
            return ((SessionContextBackedByHttpSession)((Object)SessionContextBackedByHttpSession.class.cast(context))).getSession();
        }
    }
}

