/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.async;

import java.rmi.NoSuchObjectException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.apache.openejb.AppContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.Options;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.ExecutorBuilder;

public class AsynchronousPool {
    private final BlockingQueue<Runnable> blockingQueue;
    private final ExecutorService executor;
    private final Duration awaitDuration;

    public AsynchronousPool(ThreadPoolExecutor threadPoolExecutor, Duration awaitDuration) {
        this.blockingQueue = threadPoolExecutor.getQueue();
        this.executor = threadPoolExecutor;
        this.awaitDuration = awaitDuration;
    }

    public static AsynchronousPool create(AppContext appContext) {
        Options options = appContext.getOptions();
        ExecutorBuilder builder = new ExecutorBuilder().prefix("AsynchronousPool").size(options.get("AsynchronousPool.Size", 5)).threadFactory(new DaemonThreadFactory("@Asynchronous", appContext.getId()));
        return new AsynchronousPool(builder.build(options), options.get("AsynchronousPool.ShutdownWaitDuration", new Duration(1L, TimeUnit.MINUTES)));
    }

    public Object invoke(Callable<Object> callable, boolean isVoid) throws Throwable {
        AtomicBoolean asynchronousCancelled = new AtomicBoolean(false);
        try {
            Future<Object> future = this.executor.submit(new AsynchronousCall(callable, asynchronousCancelled));
            if (isVoid) {
                return null;
            }
            return new FutureAdapter<Object>(future, asynchronousCancelled);
        }
        catch (RejectedExecutionException e) {
            throw new EJBException("fail to allocate internal resource to execute the target task", (Exception)e);
        }
    }

    public void stop() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(this.awaitDuration.getTime(), this.awaitDuration.getUnit());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class FutureAdapter<T>
    implements Future<T> {
        private final Future<T> target;
        private final AtomicBoolean asynchronousCancelled;
        private volatile boolean canceled;

        public FutureAdapter(Future<T> target, AtomicBoolean asynchronousCancelled) {
            this.target = target;
            this.asynchronousCancelled = asynchronousCancelled;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.canceled) {
                return true;
            }
            if (AsynchronousPool.this.blockingQueue.remove((Runnable)((Object)this.target))) {
                this.canceled = true;
                return true;
            }
            if (!this.target.isDone()) {
                this.asynchronousCancelled.set(mayInterruptIfRunning);
            }
            return false;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.canceled) {
                throw new CancellationException();
            }
            T object = null;
            try {
                object = this.target.get();
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            return object;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.canceled) {
                throw new CancellationException();
            }
            T object = null;
            try {
                object = this.target.get(timeout, unit);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            return object;
        }

        private void handleException(Throwable e) throws ExecutionException {
            boolean isExceptionUnchecked;
            while (e.getCause() != null) {
                e = e.getCause();
            }
            if (e instanceof NoSuchObjectException) {
                e = new NoSuchEJBException(e.getMessage(), (Exception)e);
            }
            boolean bl = isExceptionUnchecked = e instanceof Error || e instanceof RuntimeException;
            if (!isExceptionUnchecked || e instanceof EJBException) {
                throw new ExecutionException(e);
            }
            throw e instanceof Exception ? new ExecutionException((Throwable)new EJBException((Exception)e)) : new ExecutionException((Throwable)new EJBException(new Exception(e)));
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            return !this.canceled && this.target.isDone();
        }
    }

    private final class AsynchronousCall
    implements Callable<Object> {
        private final Callable<Object> callable;
        private final AtomicBoolean asynchronousCancelled;

        private AsynchronousCall(Callable<Object> callable, AtomicBoolean asynchronousCancelled) {
            this.callable = callable;
            this.asynchronousCancelled = asynchronousCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            try {
                ThreadContext.initAsynchronousCancelled(this.asynchronousCancelled);
                Object value = this.callable.call();
                if (value instanceof Future) {
                    Future future = (Future)value;
                    Object v = future.get();
                    return v;
                }
                Object var2_3 = null;
                return var2_3;
            }
            finally {
                ThreadContext.removeAsynchronousCancelled();
            }
        }
    }
}

