/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

public class StyleTypeDefinitions {
    private StyleTypeDefinitions() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WritingMode {
        LRTB("lr-tb"),
        RLTB("rl-tb"),
        TBRL("tb-rl"),
        TBLR("tb-lr"),
        LR("lr"),
        RL("rl"),
        TB("tb"),
        PAGE("page");

        private String mode;

        private WritingMode(String mode) {
            this.mode = mode;
        }

        public static WritingMode enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return PAGE;
            }
            for (WritingMode aIter : WritingMode.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return PAGE;
        }

        public String toString() {
            return this.mode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrintOrientation {
        LANDSCAPE("landscape"),
        PORTRAIT("portrait");

        private String printOrientaiton;

        private PrintOrientation(String orientation) {
            this.printOrientaiton = orientation;
        }

        public static PrintOrientation enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return PORTRAIT;
            }
            for (PrintOrientation aIter : PrintOrientation.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return PORTRAIT;
        }

        public String toString() {
            return this.printOrientaiton;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfDrawStroke {
        DASH("dash"),
        NONE("none"),
        SOLID("solid");

        private String value;

        private OdfDrawStroke(String style) {
            this.value = style;
        }

        public static OdfDrawStroke enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return NONE;
            }
            for (OdfDrawStroke aIter : OdfDrawStroke.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return NONE;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfDrawFill {
        BITMAP("bitmap"),
        GRADIENT("gradient"),
        HATCH("hatch"),
        NONE("none"),
        SOLID("solid");

        private String value;

        private OdfDrawFill(String style) {
            this.value = style;
        }

        public static OdfDrawFill enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return NONE;
            }
            for (OdfDrawFill aIter : OdfDrawFill.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return NONE;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfFontWeight {
        _100("100"),
        _200("200"),
        _300("300"),
        _400("400"),
        _500("500"),
        _600("600"),
        _700("700"),
        _800("800"),
        _900("900"),
        BOLD("bold"),
        NORMAL("normal");

        private String value;

        private OdfFontWeight(String style) {
            this.value = style;
        }

        public static OdfFontWeight enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return NORMAL;
            }
            for (OdfFontWeight aIter : OdfFontWeight.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return NORMAL;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfFontStyle {
        ITALIC("italic"),
        NORMAL("normal"),
        OBLIQUE("oblique");

        private String value;

        private OdfFontStyle(String style) {
            this.value = style;
        }

        public static OdfFontStyle enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return NORMAL;
            }
            for (OdfFontStyle aIter : OdfFontStyle.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return NORMAL;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfLineWidth {
        AUTO("auto"),
        BOLD("bold"),
        MEDIUM("medium"),
        NORMAL("normal"),
        THICK("thick"),
        THIN("thin");

        private String lineWidth;

        private OdfLineWidth(String type) {
            this.lineWidth = type;
        }

        public String toString() {
            return this.lineWidth;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameHorizontalPosition {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right"),
        FROMLEFT("from-left"),
        INSIDE("inside"),
        OUTSIDE("outside"),
        FROMINSIDE("from-inside");

        private String horizontalPos;

        private FrameHorizontalPosition(String type) {
            this.horizontalPos = type;
        }

        public static FrameHorizontalPosition enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return CENTER;
            }
            for (FrameHorizontalPosition aIter : FrameHorizontalPosition.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return CENTER;
        }

        public String toString() {
            return this.horizontalPos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameVerticalPosition {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom"),
        FROMTOP("from-top"),
        BELOW("below");

        private String verticalPos;

        private FrameVerticalPosition(String type) {
            this.verticalPos = type;
        }

        public static FrameVerticalPosition enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return MIDDLE;
            }
            for (FrameVerticalPosition aIter : FrameVerticalPosition.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return MIDDLE;
        }

        public String toString() {
            return this.verticalPos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HorizontalRelative {
        PAGE("page"),
        PAGE_CONTENT("page-content"),
        FRAME("frame"),
        FRAME_CONTENT("frame-content"),
        PARAGRAPH("paragraph"),
        PARAGRAPH_CONTENT("paragraph-content"),
        CHAR("char"),
        PAGE_START_MARGIN("page-start-margin"),
        PAGE_END_MARGIN("page-end-margin"),
        FRAME_START_MARGIN("frame-start-margin"),
        FRAME_END_MARGIN("frame-end-margin"),
        PARAGRAPH_START_MARGIN("paragraph-start-margin"),
        PARAGRAPH_END_MARGIN("paragraph-end-margin");

        private String relativeType;

        private HorizontalRelative(String type) {
            this.relativeType = type;
        }

        public static HorizontalRelative enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return PAGE;
            }
            for (HorizontalRelative aIter : HorizontalRelative.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return PAGE;
        }

        public String toString() {
            return this.relativeType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalRelative {
        PAGE("page"),
        PAGE_CONTENT("page-content"),
        FRAME("frame"),
        FRAME_CONTENT("frame-content"),
        PARAGRAPH("paragraph"),
        PARAGRAPH_CONTENT("paragraph-content"),
        CHAR("char"),
        LINE("line"),
        BASELINE("baseline"),
        TEXT("text");

        private String relativeType;

        private VerticalRelative(String type) {
            this.relativeType = type;
        }

        public static VerticalRelative enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return PAGE;
            }
            for (VerticalRelative aIter : VerticalRelative.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return PAGE;
        }

        public String toString() {
            return this.relativeType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnchorType {
        TO_PAGE("page"),
        TO_PARAGRAPH("paragraph"),
        TO_CHARACTER("char"),
        AS_CHARACTER("as-char"),
        TO_FRAME("frame");

        private String anchorType;

        private AnchorType(String type) {
            this.anchorType = type;
        }

        public static AnchorType enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return TO_PAGE;
            }
            for (AnchorType aIter : AnchorType.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return TO_PAGE;
        }

        public String toString() {
            return this.anchorType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineType {
        DOUBLE("double"),
        NONE("none"),
        SINGLE("single");

        private String lineType;

        private LineType(String type) {
            this.lineType = type;
        }

        public static LineType enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return NONE;
            }
            for (LineType aIter : LineType.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            return NONE;
        }

        public String toString() {
            return this.lineType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CellBordersType {
        TOP("top"),
        BOTTOM("bottom"),
        LEFT("left"),
        RIGHT("right"),
        DIAGONALBLTR("diagonal_bltr"),
        DIAGONALTLBR("diagonal_tlbr"),
        NONE("none"),
        ALL_FOUR("all_four"),
        LEFT_RIGHT("left_right"),
        TOP_BOTTOM("top_bottom"),
        DIAGONAL_LINES("diagonal_lines");

        private String value;

        private CellBordersType(String style) {
            this.value = style;
        }

        public static CellBordersType enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return null;
            }
            for (CellBordersType aIter : CellBordersType.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            throw new RuntimeException("Unsupported Cell Borders Type!");
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedLinearMeasure {
        PT("pt"){

            public double toINs(double measure) {
                return measure / 72.0;
            }

            public double toPTs(double measure) {
                return measure;
            }

            public double toCMs(double measure) {
                return measure / 28.3465;
            }

            public double convert(double measure, SupportedLinearMeasure measureUnit) {
                return measureUnit.toPTs(measure);
            }
        }
        ,
        IN("in"){

            public double toINs(double measure) {
                return measure;
            }

            public double toPTs(double measure) {
                return 72.0 * measure;
            }

            public double toCMs(double measure) {
                return 2.54 * measure;
            }

            public double convert(double measure, SupportedLinearMeasure measureUnit) {
                return measureUnit.toINs(measure);
            }
        }
        ,
        CM("cm"){

            public double toINs(double measure) {
                return measure / 2.54;
            }

            public double toPTs(double measure) {
                return measure * 28.3465;
            }

            public double toCMs(double measure) {
                return measure;
            }

            public double convert(double measure, SupportedLinearMeasure measureUnit) {
                return measureUnit.toPTs(measure);
            }
        };

        private String value;

        private SupportedLinearMeasure(String style) {
            this.value = style;
        }

        public double convert(double measure, SupportedLinearMeasure measureUnit) {
            throw new AbstractMethodError();
        }

        public double toINs(double measure) {
            throw new AbstractMethodError();
        }

        public double toPTs(double measure) {
            throw new AbstractMethodError();
        }

        public double toCMs(double measure) {
            throw new AbstractMethodError();
        }

        public static SupportedLinearMeasure enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return null;
            }
            for (SupportedLinearMeasure aIter : SupportedLinearMeasure.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            throw new RuntimeException("Unsupported Linear Measure!");
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfLineStyle {
        DASH("dash"),
        DOT_DASH("dot-dash"),
        DOT_DOT_DASH("dot-dot-dash"),
        DOTTED("dotted"),
        LONG_DASH("long-dash"),
        NONE("none"),
        SOLID("solid"),
        WAVE("wave");

        private String lineStyle;

        private OdfLineStyle(String value) {
            this.lineStyle = value;
        }

        public String toString() {
            return this.lineStyle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfEmphasisMarkType {
        NONE("none"),
        ACCENT_ABOVE("accent above"),
        DOT_ABOVE("dot above"),
        CIRCLE_ABOVE("circle above"),
        DISC_ABOVE("disc above"),
        ACCENT_BELOW("accent below"),
        DOT_BELOW("dot below"),
        CIRCLE_BELOW("circle below"),
        DISC_BELOW("disc below");

        private String value;

        private OdfEmphasisMarkType(String style) {
            this.value = style;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalAlignmentType {
        DEFAULT("default"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private String value;

        private VerticalAlignmentType(String style) {
            this.value = style;
        }

        public static VerticalAlignmentType enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return null;
            }
            for (VerticalAlignmentType aIter : VerticalAlignmentType.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            throw new RuntimeException("Unsupported Vertical Alignment Type!");
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HorizontalAlignmentType {
        DEFAULT("default"),
        LEFT("left"),
        RIGHT("right"),
        CENTER("center"),
        JUSTIFY("justify"),
        FILLED("filled");

        private String value;

        private HorizontalAlignmentType(String style) {
            this.value = style;
        }

        public static HorizontalAlignmentType enumValueOf(String aValue) {
            if (aValue == null || aValue.length() == 0) {
                return null;
            }
            for (HorizontalAlignmentType aIter : HorizontalAlignmentType.values()) {
                if (!aValue.equals(aIter.toString())) continue;
                return aIter;
            }
            throw new RuntimeException("Unsupported Horizontal Alignment Type!");
        }

        public String toString() {
            return this.value;
        }

        public String getAlignmentString() {
            if (this.value.equals("left")) {
                return "start";
            }
            if (this.value.equals("right")) {
                return "end";
            }
            if (this.value.equals("filled")) {
                return "start";
            }
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineThroughStyle {
        NONE("none"),
        SINGLE("single"),
        DOUBLE("double"),
        BOLD("bold"),
        WITH_X("with X"),
        WITH_SLASH("with /");

        private String value;

        private LineThroughStyle(String style) {
            this.value = style;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextLinePosition {
        REGULAR("Regular"),
        THROUGH("Through"),
        UNDER("Under"),
        THROUGHUNDER("Through_Under");

        private String textLineStyle;

        private TextLinePosition(String style) {
            this.textLineStyle = style;
        }

        public String toString() {
            return this.textLineStyle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdjustmentStyle {
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private String adjustment = "left";

        private AdjustmentStyle(String value) {
            this.adjustment = value;
        }

        public String toString() {
            return this.adjustment;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontStyle {
        REGULAR("Regular"),
        ITALIC("Italic"),
        BOLD("Bold"),
        BOLDITALIC("Bold_Italic");

        private String fontStyle;

        private FontStyle(String style) {
            this.fontStyle = style;
        }

        public String toString() {
            return this.fontStyle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineStyle {
        NONE("none"),
        SOLID("solid"),
        SINGLE("single"),
        DOUBLE("double"),
        BOLD("bold"),
        DOTTED("dotted"),
        DOTTED_BOLD("dotted (bold)"),
        DASH("dash"),
        DASH_BOLD("dash (bold)"),
        LONG_DASH("long-dash"),
        LONG_DASH_BOLD("long-dash (bold)"),
        DOT_DASH("dot-dash"),
        DOT_DASH_BOLD("dot-dash (bold)"),
        DOT_DOT_DASH("dot-dot-dash"),
        DOT_DOT_DASH_BOLD("dot-dot-dash (bold)"),
        WAVE("wave"),
        WAVE_BOLD("wave (bold)"),
        DOUBLE_WAVE("double wave");

        private String lineStyle;

        private LineStyle(String value) {
            this.lineStyle = value;
        }

        public String toString() {
            return this.lineStyle;
        }
    }
}

