/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.form.FormCheckboxElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;
import org.odftoolkit.simple.form.FormTypeDefinition;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBox
extends FormControl {
    CheckBox(FormCheckboxElement element) {
        this.mElement = element;
        this.formElement = (FormFormElement)element.getParentNode();
    }

    public static CheckBox getInstanceOf(FormCheckboxElement element) {
        CheckBox checkbox = new CheckBox(element);
        try {
            checkbox.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e) {
            Logger.getLogger(CheckBox.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this check box.");
        }
        return checkbox;
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        ((FormCheckboxElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
    }

    @Override
    public String getId() {
        return ((FormCheckboxElement)this.mElement).getFormIdAttribute();
    }

    @Override
    public void setId(String id) {
        ((FormCheckboxElement)this.mElement).setFormIdAttribute(id);
    }

    @Override
    FormPropertiesElement getFormPropertiesElementForWrite() {
        if (this.mFormProperties == null) {
            this.mFormProperties = ((FormCheckboxElement)this.mElement).newFormPropertiesElement();
        }
        return this.mFormProperties;
    }

    public void setLabel(String label) {
        ((FormCheckboxElement)this.mElement).setFormLabelAttribute(label);
    }

    public String getLabel() {
        return ((FormCheckboxElement)this.mElement).getFormLabelAttribute();
    }

    @Override
    public String getName() {
        return ((FormCheckboxElement)this.mElement).getFormNameAttribute();
    }

    @Override
    public void setName(String name) {
        ((FormCheckboxElement)this.mElement).setFormNameAttribute(name);
    }

    public void setValue(String value) {
        ((FormCheckboxElement)this.mElement).setFormValueAttribute(value);
    }

    public String getValue() {
        return ((FormCheckboxElement)this.mElement).getFormValueAttribute();
    }

    public void setDefaultState(FormTypeDefinition.FormCheckboxState state) {
        ((FormCheckboxElement)this.mElement).setFormStateAttribute(state.toString());
    }

    public FormTypeDefinition.FormCheckboxState getDefaultState() {
        String value = ((FormCheckboxElement)this.mElement).getFormStateAttribute();
        return FormTypeDefinition.FormCheckboxState.enumValueOf(value);
    }

    public void setCurrentState(FormTypeDefinition.FormCheckboxState state) {
        ((FormCheckboxElement)this.mElement).setFormCurrentStateAttribute(state.toString());
    }

    public FormTypeDefinition.FormCheckboxState getCurrentState() {
        String value = ((FormCheckboxElement)this.mElement).getFormCurrentStateAttribute();
        return FormTypeDefinition.FormCheckboxState.enumValueOf(value);
    }

    public static Iterator<FormControl> getSimpleIterator(Form container) {
        return new SimpleCheckBoxIterator(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleCheckBoxIterator
    implements Iterator<FormControl> {
        private FormFormElement containerElement;
        private CheckBox nextElement = null;
        private CheckBox tempElement = null;

        private SimpleCheckBoxIterator(Form container) {
            this.containerElement = container.getOdfElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public CheckBox next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.nextElement.remove();
        }

        private CheckBox findNext(CheckBox thisCheckBox) {
            FormCheckboxElement nextCheckBox = null;
            nextCheckBox = thisCheckBox == null ? (FormCheckboxElement)OdfElement.findFirstChildNode(FormCheckboxElement.class, (Node)this.containerElement) : (FormCheckboxElement)OdfElement.findNextChildNode(FormCheckboxElement.class, (Node)thisCheckBox.getOdfElement());
            if (nextCheckBox != null) {
                return CheckBox.getInstanceOf(nextCheckBox);
            }
            return null;
        }
    }
}

