/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.el.MethodExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.ComponentProcessor;
import org.apache.myfaces.trinidad.component.FlattenedComponent;
import org.apache.myfaces.trinidad.component.visit.VisitCallback;
import org.apache.myfaces.trinidad.component.visit.VisitContext;
import org.apache.myfaces.trinidad.component.visit.VisitHint;
import org.apache.myfaces.trinidad.component.visit.VisitResult;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.event.AttributeChangeListener;
import org.apache.myfaces.trinidad.render.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIXComponent
extends UIComponent {
    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        return UIXComponent.processFlattenedChildren(context, new ComponentProcessingContext(), childProcessor, child, callbackContext);
    }

    public static <S> boolean encodeFlattenedChild(FacesContext context, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        ComponentProcessingContext processingContext = new ComponentProcessingContext();
        processingContext.__setIsRendering();
        return UIXComponent.processFlattenedChildren(context, processingContext, childProcessor, child, callbackContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessingContext cpContext, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        if (child.isRendered()) {
            if (child instanceof FlattenedComponent && ((FlattenedComponent)child).isFlatteningChildren(context)) {
                return ((FlattenedComponent)child).processFlattenedChildren(context, cpContext, childProcessor, callbackContext);
            }
            try {
                childProcessor.processComponent(context, cpContext, child, callbackContext);
            }
            finally {
                cpContext.resetStartDepth();
            }
            return true;
        }
        return false;
    }

    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        return UIXComponent.processFlattenedChildren(context, new ComponentProcessingContext(), childProcessor, children, callbackContext);
    }

    public static <S> boolean encodeFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        ComponentProcessingContext processingContext = new ComponentProcessingContext();
        processingContext.__setIsRendering();
        return UIXComponent.processFlattenedChildren(context, processingContext, childProcessor, children, callbackContext);
    }

    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessingContext cpContext, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        boolean processedChild = false;
        for (UIComponent currChild : children) {
            processedChild |= UIXComponent.processFlattenedChildren(context, cpContext, childProcessor, currChild, callbackContext);
        }
        return processedChild;
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        return UIXComponent.visitTree(visitContext, this, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean visitTree(VisitContext visitContext, UIComponent component, VisitCallback callback) {
        VisitResult result;
        UIXComponent uixComponent;
        if (component instanceof UIXComponent) {
            uixComponent = (UIXComponent)component;
            if (!uixComponent.isVisitable(visitContext)) {
                return false;
            }
        } else {
            if (!UIXComponent._isVisitable(visitContext, component)) {
                return false;
            }
            uixComponent = null;
        }
        if ((result = visitContext.invokeVisitCallback(component, callback)) == VisitResult.COMPLETE) {
            return true;
        }
        if (result == VisitResult.ACCEPT) {
            RenderingContext rc;
            FacesContext context = visitContext.getFacesContext();
            PhaseId phaseId = visitContext.getPhaseId();
            RenderingContext renderingContext = rc = PhaseId.RENDER_RESPONSE == phaseId ? RenderingContext.getCurrentInstance() : null;
            if (uixComponent != null) {
                if (uixComponent instanceof NamingContainer && visitContext.getSubtreeIdsToVisit(uixComponent).isEmpty()) {
                    return false;
                }
                if (PhaseId.RENDER_RESPONSE == phaseId) {
                    uixComponent.setUpEncodingContext(context, rc);
                } else {
                    uixComponent.setupVisitingContext(context);
                }
            } else if (UINamingContainer.class == component.getClass() && visitContext.getSubtreeIdsToVisit(component).isEmpty()) {
                return false;
            }
            try {
                Iterator kids = component.getFacetsAndChildren();
                while (kids.hasNext()) {
                    boolean done;
                    UIComponent currChild = (UIComponent)kids.next();
                    if (currChild instanceof UIXComponent) {
                        UIXComponent uixChild = (UIXComponent)currChild;
                        done = uixChild.visitTree(visitContext, callback);
                    } else {
                        done = UIXComponent.visitTree(visitContext, currChild, callback);
                    }
                    if (!done) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (uixComponent != null) {
                    if (PhaseId.RENDER_RESPONSE == phaseId) {
                        uixComponent.tearDownEncodingContext(context, rc);
                    } else {
                        uixComponent.tearDownVisitingContext(context);
                    }
                }
            }
        }
        assert (result == VisitResult.REJECT);
        return false;
    }

    public static void addPartialTarget(FacesContext facesContext, PartialPageContext partialContext, UIComponent component) {
        if (component == null) {
            throw new NullPointerException("UIComponent is null");
        }
        if (component instanceof UIXComponent) {
            ((UIXComponent)component).setPartialTarget(facesContext, partialContext);
        } else {
            UIXComponent._addPartialTargetImpl(facesContext, partialContext, component);
        }
    }

    protected void setPartialTarget(FacesContext facesContext, PartialPageContext partialContext) {
        UIXComponent._addPartialTargetImpl(facesContext, partialContext, this);
    }

    protected boolean isVisitable(VisitContext visitContext) {
        return UIXComponent._isVisitable(visitContext, this);
    }

    private static void _addPartialTargetImpl(FacesContext facesContext, PartialPageContext partialContext, UIComponent component) {
        if (component.getRendererType() == null) {
            if (component.getParent() != null) {
                UIXComponent.addPartialTarget(facesContext, partialContext, component.getParent());
            }
        } else {
            partialContext.addPartialTarget(component.getClientId(facesContext));
        }
    }

    private static boolean _isVisitable(VisitContext visitContext, UIComponent component) {
        Set<VisitHint> hints = visitContext.getHints();
        if (hints.contains((Object)VisitHint.SKIP_TRANSIENT) && component.isTransient()) {
            return false;
        }
        return !hints.contains((Object)VisitHint.SKIP_UNRENDERED) || component.isRendered();
    }

    public VisitResult partialEncodeVisit(VisitContext visitContext, PartialPageContext partialContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        Renderer renderer = this.getRenderer(context);
        if (renderer instanceof CoreRenderer) {
            return ((CoreRenderer)renderer).partialEncodeVisit(visitContext, partialContext, this, callback);
        }
        if (partialContext.isPossiblePartialTarget(this.getId()) && partialContext.isPartialTarget(this.getClientId(context))) {
            return callback.visit(visitContext, this);
        }
        return VisitResult.ACCEPT;
    }

    protected void setupVisitingContext(FacesContext context) {
    }

    protected void tearDownVisitingContext(FacesContext context) {
    }

    protected void setUpEncodingContext(FacesContext context, RenderingContext rc) {
        this.setupVisitingContext(context);
        Renderer renderer = this.getRenderer(context);
        if (renderer instanceof CoreRenderer) {
            CoreRenderer coreRenderer = (CoreRenderer)renderer;
            coreRenderer.setupEncodingContext(context, rc, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownEncodingContext(FacesContext context, RenderingContext rc) {
        Renderer renderer = this.getRenderer(context);
        try {
            if (renderer instanceof CoreRenderer) {
                CoreRenderer coreRenderer = (CoreRenderer)renderer;
                coreRenderer.tearDownEncodingContext(context, rc, this);
            }
        }
        finally {
            this.tearDownVisitingContext(context);
        }
    }

    public abstract FacesBean getFacesBean();

    public abstract void addAttributeChangeListener(AttributeChangeListener var1);

    public abstract void removeAttributeChangeListener(AttributeChangeListener var1);

    public abstract AttributeChangeListener[] getAttributeChangeListeners();

    public abstract void setAttributeChangeListener(MethodExpression var1);

    public abstract MethodExpression getAttributeChangeListener();

    public abstract void markInitialState();

    public abstract String getContainerClientId(FacesContext var1, UIComponent var2);
}

