/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.jsch;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.providers.ssh.AbstractSshWagon;
import org.apache.maven.wagon.providers.ssh.CommandExecutorStreamProcessor;
import org.apache.maven.wagon.providers.ssh.jsch.WagonUserInfo;
import org.apache.maven.wagon.providers.ssh.jsch.interactive.UserInfoUIKeyboardInteractiveProxy;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostChangedException;
import org.apache.maven.wagon.providers.ssh.knownhost.UnknownHostException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringInputStream;

public abstract class AbstractJschWagon
extends AbstractSshWagon {
    protected Session session;
    private UIKeyboardInteractive uIKeyboardInteractive;
    private static final int SOCKS5_PROXY_PORT = 1080;
    protected static final String EXEC_CHANNEL = "exec";

    public void openConnection() throws AuthenticationException {
        super.openConnection();
        if (!((AbstractWagon)this).interactive) {
            this.uIKeyboardInteractive = null;
        }
        JSch sch = new JSch();
        File privateKey = this.getPrivateKey();
        if (privateKey != null && privateKey.exists()) {
            try {
                sch.addIdentity(privateKey.getAbsolutePath(), ((AbstractWagon)this).authenticationInfo.getPassphrase());
            }
            catch (JSchException e) {
                throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
        String host = this.getRepository().getHost();
        int port = this.getPort();
        try {
            this.session = sch.getSession(((AbstractWagon)this).authenticationInfo.getUserName(), host, port);
        }
        catch (JSchException e) {
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
        }
        if (((AbstractWagon)this).proxyInfo != null && ((AbstractWagon)this).proxyInfo.getHost() != null) {
            ProxySOCKS5 proxy;
            int proxyPort = ((AbstractWagon)this).proxyInfo.getPort();
            if (proxyPort == 1080) {
                proxy = new ProxySOCKS5(((AbstractWagon)this).proxyInfo.getHost());
                proxy.setUserPasswd(((AbstractWagon)this).proxyInfo.getUserName(), ((AbstractWagon)this).proxyInfo.getPassword());
            } else {
                proxy = new ProxyHTTP(((AbstractWagon)this).proxyInfo.getHost(), proxyPort);
                ((ProxyHTTP)proxy).setUserPasswd(((AbstractWagon)this).proxyInfo.getUserName(), ((AbstractWagon)this).proxyInfo.getPassword());
            }
            this.session.setProxy((Proxy)proxy);
        } else {
            this.session.setProxy(null);
        }
        Object ui = new WagonUserInfo(((AbstractWagon)this).authenticationInfo, this.interactiveUserInfo);
        if (this.uIKeyboardInteractive != null) {
            ui = new UserInfoUIKeyboardInteractiveProxy((UserInfo)ui, this.uIKeyboardInteractive);
        }
        Properties config = new Properties();
        if (this.knownHostsProvider != null) {
            try {
                String contents = this.knownHostsProvider.getContents();
                if (contents != null) {
                    sch.setKnownHosts((InputStream)new StringInputStream(contents));
                }
            }
            catch (JSchException e) {
                // empty catch block
            }
            config.setProperty("StrictHostKeyChecking", this.knownHostsProvider.getHostKeyChecking());
        }
        config.setProperty("BatchMode", ((AbstractWagon)this).interactive ? "no" : "yes");
        this.session.setConfig(config);
        this.session.setUserInfo((UserInfo)ui);
        StringWriter stringWriter = new StringWriter();
        try {
            this.session.connect();
            if (this.knownHostsProvider != null) {
                PrintWriter w = new PrintWriter(stringWriter);
                HostKeyRepository hkr = sch.getHostKeyRepository();
                HostKey[] keys = hkr.getHostKey();
                for (int i = 0; i < keys.length; ++i) {
                    HostKey key = keys[i];
                    w.println(key.getHost() + " " + key.getType() + " " + key.getKey());
                }
            }
        }
        catch (JSchException e) {
            if (e.getMessage().startsWith("UnknownHostKey:") || e.getMessage().startsWith("reject HostKey:")) {
                throw new UnknownHostException(host, (Throwable)e);
            }
            if (e.getMessage().indexOf("HostKey has been changed") >= 0) {
                throw new KnownHostChangedException(host, (Throwable)e);
            }
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.knownHostsProvider.storeKnownHosts(stringWriter.toString());
        }
        catch (IOException e) {
            this.closeConnection();
            throw new AuthenticationException("Connection aborted - failed to write to known_hosts. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public void closeConnection() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Streams executeCommand(String command, boolean ignoreFailures) throws CommandExecutionException {
        Streams streams;
        ChannelExec channel = null;
        BufferedReader stdoutReader = null;
        BufferedReader stderrReader = null;
        try {
            try {
                channel = (ChannelExec)this.session.openChannel(EXEC_CHANNEL);
                channel.setCommand(command + "\n");
                InputStream stdout = channel.getInputStream();
                InputStream stderr = channel.getErrStream();
                channel.connect();
                stdoutReader = new BufferedReader(new InputStreamReader(stdout));
                stderrReader = new BufferedReader(new InputStreamReader(stderr));
                Streams streams2 = CommandExecutorStreamProcessor.processStreams((BufferedReader)stderrReader, (BufferedReader)stdoutReader);
                if (streams2.getErr().length() > 0) {
                    int exitCode = channel.getExitStatus();
                    throw new CommandExecutionException("Exit code: " + exitCode + " - " + streams2.getErr());
                }
                streams = streams2;
                Object var11_13 = null;
            }
            catch (IOException e) {
                throw new CommandExecutionException("Cannot execute remote command: " + command, (Throwable)e);
            }
            catch (JSchException e) {
                throw new CommandExecutionException("Cannot execute remote command: " + command, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            IOUtil.close(stdoutReader);
            IOUtil.close(stderrReader);
            if (channel == null) throw throwable;
            channel.disconnect();
            throw throwable;
        }
        IOUtil.close((Reader)stdoutReader);
        IOUtil.close((Reader)stderrReader);
        if (channel == null) return streams;
        channel.disconnect();
        return streams;
    }
}

