/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.TestNgTestSuite;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGExecutor {
    private TestNGExecutor() {
    }

    public static void run(Class[] testClasses, String testSourceDirectory, Map options, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory, String methodNamePattern) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator((String)options.get("testng.configurator"));
        System.out.println("Configuring TestNG with: " + configurator.getClass().getSimpleName());
        XmlMethodSelector groupMatchingSelector = TestNGExecutor.getGroupMatchingSelector(options);
        XmlMethodSelector methodNameFilteringSelector = TestNGExecutor.getMethodNameFilteringSelector(methodNamePattern);
        ArrayList<XmlSuite> suites = new ArrayList<XmlSuite>(testClasses.length);
        for (Class testClass : testClasses) {
            XmlSuite xmlSuite = new XmlSuite();
            xmlSuite.setName(testClass.getName());
            configurator.configure(xmlSuite, options);
            XmlTest xmlTest = new XmlTest(xmlSuite);
            xmlTest.setXmlClasses(Arrays.asList(new XmlClass(testClass)));
            TestNGExecutor.addSelector(xmlTest, groupMatchingSelector);
            TestNGExecutor.addSelector(xmlTest, methodNameFilteringSelector);
            suites.add(xmlSuite);
        }
        testng.setXmlSuites(suites);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, reportManager, suite, reportsDirectory);
        testng.run();
    }

    private static void addSelector(XmlTest xmlTest, XmlMethodSelector selector) {
        if (selector != null) {
            xmlTest.getMethodSelectors().add(selector);
        }
    }

    private static XmlMethodSelector getMethodNameFilteringSelector(String methodNamePattern) throws TestSetFailedException {
        if (StringUtils.isBlank((String)methodNamePattern)) {
            return null;
        }
        String clazzName = "org.apache.maven.surefire.testng.utils.MethodSelector";
        try {
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod("setMethodName", String.class);
            method.invoke(null, methodNamePattern);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        XmlMethodSelector xms = new XmlMethodSelector();
        xms.setName(clazzName);
        xms.setPriority(10000);
        return xms;
    }

    private static XmlMethodSelector getGroupMatchingSelector(Map options) throws TestSetFailedException {
        String groups = (String)options.get("groups");
        String excludedGroups = (String)options.get("excludegroups");
        if (groups == null && excludedGroups == null) {
            return null;
        }
        String clazzName = "org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector";
        try {
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod("setGroups", String.class, String.class);
            method.invoke(null, groups, excludedGroups);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        XmlMethodSelector xms = new XmlMethodSelector();
        xms.setName(clazzName);
        xms.setPriority(9999);
        return xms;
    }

    public static void run(List<String> suiteFiles, String testSourceDirectory, Map options, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator((String)options.get("testng.configurator"));
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, reportManager, suite, reportsDirectory);
        testng.setTestSuites(suiteFiles);
        testng.run();
    }

    private static Configurator getConfigurator(String className) {
        try {
            return (Configurator)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void postConfigure(TestNG testNG, String sourcePath, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        testNG.setVerbose(0);
        TestNGReporter reporter = TestNGExecutor.createTestNGReporter(reportManager, suite);
        testNG.addListener((Object)reporter);
        if (sourcePath != null) {
            testNG.setSourcePath(sourcePath);
        }
        testNG.setOutputDirectory(reportsDirectory.getAbsolutePath());
    }

    private static TestNGReporter createTestNGReporter(RunListener reportManager, TestNgTestSuite suite) {
        try {
            Class.forName("org.testng.internal.IResultListener");
            Class<?> c = Class.forName("org.apache.maven.surefire.testng.ConfigurationAwareTestNGReporter");
            try {
                Constructor<?> ctor = c.getConstructor(RunListener.class, TestNgTestSuite.class);
                return (TestNGReporter)ctor.newInstance(reportManager, suite);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Bug in ConfigurationAwareTestNGReporter", (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            return new TestNGReporter(reportManager);
        }
    }
}

