/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.command.list;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.local.command.list.LocalListScmResult;
import org.apache.maven.scm.provider.local.repository.LocalScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class LocalListCommand
extends AbstractListCommand {
    protected ListScmResult executeListCommand(ScmProviderRepository repo, ScmFileSet fileSet, boolean recursive, ScmVersion version) throws ScmException {
        if (version != null) {
            throw new ScmException("The local scm doesn't support tags.");
        }
        LocalScmProviderRepository repository = (LocalScmProviderRepository)repo;
        File root = new File(repository.getRoot());
        String module = repository.getModule();
        File source = new File(root, module);
        if (!root.exists()) {
            throw new ScmException("The base directory doesn't exist (" + root.getAbsolutePath() + ").");
        }
        if (!source.exists()) {
            throw new ScmException("The module directory doesn't exist (" + source.getAbsolutePath() + ").");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Listing files of '" + source.getAbsolutePath() + "'.");
        }
        try {
            if (fileSet.getFileList() == null || fileSet.getFileList().isEmpty()) {
                return new LocalListScmResult(null, this.getFiles(source, source, recursive));
            }
            ArrayList files = new ArrayList();
            Iterator it = fileSet.getFileList().iterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                files.addAll(this.getFiles(source, new File(source, file.getPath()), recursive));
            }
            return new LocalListScmResult(null, files);
        }
        catch (Exception e) {
            return new ListScmResult(null, "The svn command failed.", e.getMessage(), false);
        }
    }

    private List getFiles(File source, File directory, boolean recursive) throws Exception {
        if (!directory.exists()) {
            throw new Exception("Directory '" + directory.getAbsolutePath() + "' doesn't exist.");
        }
        ArrayList<ScmFile> files = new ArrayList<ScmFile>();
        File[] filesArray = directory.listFiles();
        if (filesArray != null) {
            for (int i = 0; i < filesArray.length; ++i) {
                File f = filesArray[i];
                String path = f.getAbsolutePath().substring(source.getAbsolutePath().length());
                path = StringUtils.replace((String)path, (String)"\\", (String)"/");
                path = StringUtils.replace((String)path, (String)"/./", (String)"/");
                files.add(new ScmFile(path, ScmFileStatus.CHECKED_IN));
                if (!f.isDirectory() || !recursive) continue;
                files.addAll(this.getFiles(source, f, recursive));
            }
        }
        return files;
    }
}

