/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.util.StringUtils;
import org.slf4j.Logger;

public class ScmProviderAwareSshdSessionFactory
extends SshdSessionFactory {
    private final GitScmProviderRepository repo;
    private final Logger logger;

    public ScmProviderAwareSshdSessionFactory(GitScmProviderRepository repo, Logger logger) {
        this.repo = repo;
        this.logger = logger;
    }

    protected List<Path> getDefaultIdentities(File sshDir) {
        if (!StringUtils.isEmptyOrNull((String)this.repo.getPrivateKey())) {
            this.logger.debug("Using private key at {}", (Object)this.repo.getPrivateKey());
            return Collections.singletonList(Paths.get(this.repo.getPrivateKey(), new String[0]));
        }
        return super.getDefaultIdentities(sshDir);
    }

    protected KeyPasswordProvider createKeyPasswordProvider(CredentialsProvider provider) {
        if (this.repo.getPassphrase() != null) {
            return new IdentityPasswordProvider(provider){

                public char[] getPassphrase(URIish uri, int attempt) throws IOException {
                    if (attempt > 0) {
                        throw new IOException("Passphrase was not correct in first attempt, canceling further attempts!");
                    }
                    ScmProviderAwareSshdSessionFactory.this.logger.debug("Using stored passphrase");
                    return ScmProviderAwareSshdSessionFactory.this.repo.getPassphrase().toCharArray();
                }
            };
        }
        return super.createKeyPasswordProvider(provider);
    }
}

