/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.SiteDeployMojo;
import org.apache.maven.plugins.site.SiteStageMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.legacy.WagonConfigurationException;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteStageDeployMojo
extends SiteStageMojo {
    private String stagingSiteURL;
    private String stagingRepositoryId;
    private boolean chmod;
    private String chmodMode;
    private String chmodOptions;
    private WagonManager wagonManager;
    private Settings settings;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.deployStagingSite();
    }

    private void deployStagingSite() throws MojoExecutionException, MojoFailureException {
        Wagon wagon;
        this.stagingSiteURL = this.getStagingSiteURL(this.project, this.reactorProjects, this.stagingSiteURL);
        this.getLog().info((CharSequence)("Using this URL for staging: " + this.stagingSiteURL));
        Repository repository = new Repository(this.stagingRepositoryId, this.stagingSiteURL);
        try {
            wagon = this.wagonManager.getWagon(repository);
            SiteDeployMojo.configureWagon(wagon, this.stagingRepositoryId, this.settings, this.plexusContainer, this.getLog());
            wagon.connect(repository);
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (WagonConfigurationException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("AuthenticationException : Unable to connect Wagon to repository : '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Unable to connect Wagon to repository : '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        try {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
            wagon.connect(repository);
            wagon.putDirectory(new File(this.stagingDirectory, SiteStageDeployMojo.getStructure(this.project, false)), ".");
            this.getLog().debug((CharSequence)"putDirectory end ok ");
            if (this.chmod && wagon instanceof CommandExecutor) {
                CommandExecutor exec = (CommandExecutor)wagon;
                exec.executeCommand("chmod " + this.chmodOptions + " " + this.chmodMode + " " + repository.getBasedir());
            }
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (CommandExecutionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }

    protected String getStagingSiteURL(MavenProject currentProject, List<MavenProject> reactorProjects, String usersStagingSiteURL) {
        String topLevelURL = null;
        String relative = "";
        if (usersStagingSiteURL != null) {
            this.getLog().debug((CharSequence)"stagingSiteURL specified by the user.");
            topLevelURL = usersStagingSiteURL;
        }
        this.getLog().debug((CharSequence)"stagingSiteURL NOT specified by the user.");
        MavenProject topLevelProject = this.getTopLevelProject(reactorProjects);
        if (topLevelProject == null) {
            if (topLevelURL == null) {
                this.getLog().debug((CharSequence)"No top level project found in the reactor, using the current project.");
                topLevelURL = currentProject.getDistributionManagement().getSite().getUrl() + "/" + "staging";
            }
        } else {
            relative = "/" + this.siteTool.getRelativePath(currentProject.getDistributionManagement().getSite().getUrl(), topLevelProject.getDistributionManagement().getSite().getUrl());
            relative = relative.replace('\\', '/');
            if (topLevelURL == null) {
                this.getLog().debug((CharSequence)"Using the top level project found in the reactor.");
                topLevelURL = topLevelProject.getDistributionManagement().getSite().getUrl() + "/" + "staging";
            }
        }
        return topLevelURL + relative;
    }
}

