/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.StringUtils;

public class ApacheNoticeResourceTransformer
implements ResourceTransformer {
    Set entries = new LinkedHashSet();
    Map organizationEntries = new LinkedHashMap();
    String projectName;
    boolean addHeader = true;
    String preamble1 = "// ------------------------------------------------------------------\n// NOTICE file corresponding to the section 4d of The Apache License,\n// Version 2.0, in this case for ";
    String preamble2 = "\n// ------------------------------------------------------------------\n";
    String preamble3 = "This product includes software developed at\n";
    String organizationName = "The Apache Software Foundation";
    String organizationURL = "http://www.apache.org/";
    String inceptionYear = "2006";
    String copyright;
    String encoding;
    private static final String NOTICE_PATH = "META-INF/NOTICE";
    private static final String NOTICE_TXT_PATH = "META-INF/NOTICE.txt";

    public boolean canTransformResource(String resource) {
        return NOTICE_PATH.equalsIgnoreCase(resource) || NOTICE_TXT_PATH.equalsIgnoreCase(resource);
    }

    public void processResource(InputStream is) throws IOException {
        if (this.entries.isEmpty()) {
            String year = new SimpleDateFormat("yyyy").format(new Date());
            if (!this.inceptionYear.equals(year)) {
                year = this.inceptionYear + "-" + year;
            }
            if (this.addHeader) {
                this.entries.add(this.preamble1 + this.projectName + this.preamble2);
            } else {
                this.entries.add("");
            }
            this.entries.add(this.projectName + "\nCopyright " + year + " " + this.organizationName + "\n");
            this.entries.add(this.preamble3 + this.organizationName + " (" + this.organizationURL + ").\n");
        }
        BufferedReader reader = StringUtils.isNotEmpty((String)this.encoding) ? new BufferedReader(new InputStreamReader(is, this.encoding)) : new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        StringBuffer sb = new StringBuffer();
        Set<String> currentOrg = null;
        int lineCount = 0;
        while (line != null) {
            String trimedLine = line.trim();
            if (!trimedLine.startsWith("//")) {
                if (trimedLine.length() > 0) {
                    if (trimedLine.startsWith("- ")) {
                        if (lineCount == 1 && sb.toString().indexOf("This product includes/uses software(s) developed by") != -1) {
                            currentOrg = (Set)this.organizationEntries.get(sb.toString().trim());
                            if (currentOrg == null) {
                                currentOrg = new TreeSet<String>();
                                this.organizationEntries.put(sb.toString().trim(), currentOrg);
                            }
                            sb = new StringBuffer();
                        } else if (sb.length() > 0 && currentOrg != null) {
                            currentOrg.add(sb.toString());
                            sb = new StringBuffer();
                        }
                    }
                    sb.append(line).append("\n");
                    ++lineCount;
                } else {
                    String ent = sb.toString();
                    if (ent.startsWith(this.projectName) && ent.indexOf("Copyright ") != -1) {
                        this.copyright = ent;
                    }
                    if (currentOrg == null) {
                        this.entries.add(ent);
                    } else {
                        currentOrg.add(ent);
                    }
                    sb = new StringBuffer();
                    lineCount = 0;
                    currentOrg = null;
                }
            }
            line = reader.readLine();
        }
        if (sb.length() > 0) {
            if (currentOrg == null) {
                this.entries.add(sb.toString());
            } else {
                currentOrg.add(sb.toString());
            }
        }
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        jos.putNextEntry(new JarEntry(NOTICE_PATH));
        OutputStreamWriter pow = StringUtils.isNotEmpty((String)this.encoding) ? new OutputStreamWriter((OutputStream)jos, this.encoding) : new OutputStreamWriter(jos);
        PrintWriter writer = new PrintWriter(pow);
        int count = 0;
        Iterator itr = this.entries.iterator();
        while (itr.hasNext()) {
            String line = (String)itr.next();
            if (line.equals(this.copyright) && ++count != 2) continue;
            if (count == 2 && this.copyright != null) {
                writer.print(this.copyright);
                writer.print('\n');
            } else {
                writer.print(line);
                writer.print('\n');
            }
            if (count != 3) continue;
            Iterator oit = this.organizationEntries.entrySet().iterator();
            while (oit.hasNext()) {
                Map.Entry entry = oit.next();
                writer.print(entry.getKey().toString());
                writer.print('\n');
                Set entrySet = (Set)entry.getValue();
                Iterator eit = entrySet.iterator();
                while (eit.hasNext()) {
                    writer.print(eit.next().toString());
                }
                writer.print('\n');
            }
        }
        writer.flush();
        this.entries.clear();
    }
}

