/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="display-ancestors", threadSafe=true, requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE)
public class DisplayAncestorsMojo
extends AbstractMojo {
    private MavenProject project;

    @Inject
    public DisplayAncestorsMojo(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> ancestors = this.collectAncestors();
        if (ancestors.isEmpty()) {
            this.getLog().info((CharSequence)"No Ancestor POMs!");
        } else {
            this.getLog().info((CharSequence)("Ancestor POMs: " + String.join((CharSequence)" <- ", ancestors)));
        }
    }

    private ArrayList<String> collectAncestors() {
        ArrayList<String> ancestors = new ArrayList<String>();
        for (MavenProject currentAncestor = this.project.getParent(); currentAncestor != null; currentAncestor = currentAncestor.getParent()) {
            ancestors.add(currentAncestor.getGroupId() + ":" + currentAncestor.getArtifactId() + ":" + currentAncestor.getVersion());
        }
        return ancestors;
    }
}

