/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.java;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.descriptor.InvalidParameterException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.Requirement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.java.JavaMojoAnnotation;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

public class JavaMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor,
JavaMojoAnnotation {
    public static final String MAVEN_PLUGIN_INSTANTIATION = "instantiationStrategy";
    public static final String CONFIGURATOR = "configurator";
    public static final String PARAMETER = "parameter";
    public static final String PARAMETER_EXPRESSION = "expression";
    public static final String PARAMETER_DEFAULT_VALUE = "default-value";
    public static final String PARAMETER_ALIAS = "alias";
    public static final String SINCE = "since";
    public static final String PARAMETER_IMPLEMENTATION = "implementation";
    public static final String PARAMETER_PROPERTY = "property";
    public static final String REQUIRED = "required";
    public static final String DEPRECATED = "deprecated";
    public static final String READONLY = "readonly";
    public static final String GOAL = "goal";
    public static final String PHASE = "phase";
    public static final String EXECUTE = "execute";
    public static final String EXECUTE_LIFECYCLE = "lifecycle";
    public static final String EXECUTE_PHASE = "phase";
    public static final String EXECUTE_GOAL = "goal";
    public static final String GOAL_DESCRIPTION = "description";
    public static final String GOAL_REQUIRES_DEPENDENCY_RESOLUTION = "requiresDependencyResolution";
    public static final String GOAL_REQUIRES_PROJECT = "requiresProject";
    public static final String GOAL_REQUIRES_REPORTS = "requiresReports";
    public static final String GOAL_IS_AGGREGATOR = "aggregator";
    public static final String GOAL_REQUIRES_ONLINE = "requiresOnline";
    public static final String GOAL_INHERIT_BY_DEFAULT = "inheritByDefault";
    public static final String GOAL_MULTI_EXECUTION_STRATEGY = "attainAlways";
    public static final String GOAL_REQUIRES_DIRECT_INVOCATION = "requiresDirectInvocation";
    public static final String COMPONENT = "component";
    public static final String COMPONENT_ROLE = "role";
    public static final String COMPONENT_ROLEHINT = "roleHint";

    protected void validateParameter(Parameter parameter, int i) throws InvalidParameterException {
        String name = parameter.getName();
        if (name == null) {
            throw new InvalidParameterException("name", i);
        }
        String type = parameter.getType();
        if (type == null) {
            throw new InvalidParameterException("type", i);
        }
        String description = parameter.getDescription();
        if (description == null) {
            throw new InvalidParameterException(GOAL_DESCRIPTION, i);
        }
    }

    protected MojoDescriptor createMojoDescriptor(JavaClass javaClass) throws InvalidPluginDescriptorException {
        DocletTag since;
        DocletTag requiresDependencyResolution;
        DocletTag goal;
        DocletTag execute;
        DocletTag configurator;
        MojoDescriptor mojoDescriptor = new MojoDescriptor();
        mojoDescriptor.setLanguage("java");
        mojoDescriptor.setImplementation(javaClass.getFullyQualifiedName());
        mojoDescriptor.setDescription(javaClass.getComment());
        DocletTag aggregator = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, GOAL_IS_AGGREGATOR);
        if (aggregator != null) {
            mojoDescriptor.setAggregator(true);
        }
        if ((configurator = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, CONFIGURATOR)) != null) {
            mojoDescriptor.setComponentConfigurator(configurator.getValue());
        }
        if ((execute = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, EXECUTE)) != null) {
            String executePhase = execute.getNamedParameter("phase");
            String executeGoal = execute.getNamedParameter("goal");
            if (executePhase == null && executeGoal == null) {
                throw new InvalidPluginDescriptorException("@execute tag requires a 'phase' or 'goal' parameter");
            }
            if (executePhase != null && executeGoal != null) {
                throw new InvalidPluginDescriptorException("@execute tag can have only one of a 'phase' or 'goal' parameter");
            }
            mojoDescriptor.setExecutePhase(executePhase);
            mojoDescriptor.setExecuteGoal(executeGoal);
            String lifecycle = execute.getNamedParameter(EXECUTE_LIFECYCLE);
            if (lifecycle != null) {
                mojoDescriptor.setExecuteLifecycle(lifecycle);
                if (mojoDescriptor.getExecuteGoal() != null) {
                    throw new InvalidPluginDescriptorException("@execute lifecycle requires a phase instead of a goal");
                }
            }
        }
        if ((goal = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, "goal")) != null) {
            mojoDescriptor.setGoal(goal.getValue());
        }
        boolean value = JavaMojoDescriptorExtractor.getBooleanTagValue(javaClass, GOAL_INHERIT_BY_DEFAULT, mojoDescriptor.isInheritedByDefault());
        mojoDescriptor.setInheritedByDefault(value);
        DocletTag tag = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, MAVEN_PLUGIN_INSTANTIATION);
        if (tag != null) {
            mojoDescriptor.setInstantiationStrategy(tag.getValue());
        }
        if ((tag = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, GOAL_MULTI_EXECUTION_STRATEGY)) != null) {
            mojoDescriptor.setExecutionStrategy("always");
        } else {
            mojoDescriptor.setExecutionStrategy("once-per-session");
        }
        DocletTag phase = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, "phase");
        if (phase != null) {
            mojoDescriptor.setPhase(phase.getValue());
        }
        if ((requiresDependencyResolution = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, GOAL_REQUIRES_DEPENDENCY_RESOLUTION)) != null) {
            String v = requiresDependencyResolution.getValue();
            if (StringUtils.isEmpty((String)v)) {
                v = "runtime";
            }
            mojoDescriptor.setDependencyResolutionRequired(v);
        }
        value = JavaMojoDescriptorExtractor.getBooleanTagValue(javaClass, GOAL_REQUIRES_DIRECT_INVOCATION, mojoDescriptor.isDirectInvocationOnly());
        mojoDescriptor.setDirectInvocationOnly(value);
        value = JavaMojoDescriptorExtractor.getBooleanTagValue(javaClass, GOAL_REQUIRES_ONLINE, mojoDescriptor.isOnlineRequired());
        mojoDescriptor.setOnlineRequired(value);
        value = JavaMojoDescriptorExtractor.getBooleanTagValue(javaClass, GOAL_REQUIRES_PROJECT, mojoDescriptor.isProjectRequired());
        mojoDescriptor.setProjectRequired(value);
        value = JavaMojoDescriptorExtractor.getBooleanTagValue(javaClass, GOAL_REQUIRES_REPORTS, mojoDescriptor.isRequiresReports());
        mojoDescriptor.setRequiresReports(value);
        DocletTag deprecated = javaClass.getTagByName(DEPRECATED);
        if (deprecated != null) {
            mojoDescriptor.setDeprecated(deprecated.getValue());
        }
        if ((since = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, SINCE)) != null) {
            mojoDescriptor.setSince(since.getValue());
        }
        this.extractParameters(mojoDescriptor, javaClass);
        return mojoDescriptor;
    }

    private static boolean getBooleanTagValue(JavaClass javaClass, String tagName, boolean defaultValue) {
        String value;
        DocletTag tag = JavaMojoDescriptorExtractor.findInClassHierarchy(javaClass, tagName);
        if (tag != null && StringUtils.isNotEmpty((String)(value = tag.getValue()))) {
            defaultValue = Boolean.valueOf(value);
        }
        return defaultValue;
    }

    private static DocletTag findInClassHierarchy(JavaClass javaClass, String tagName) {
        JavaClass superClass;
        DocletTag tag = javaClass.getTagByName(tagName);
        if (tag == null && (superClass = javaClass.getSuperJavaClass()) != null) {
            tag = JavaMojoDescriptorExtractor.findInClassHierarchy(superClass, tagName);
        }
        return tag;
    }

    private void extractParameters(MojoDescriptor mojoDescriptor, JavaClass javaClass) throws InvalidPluginDescriptorException {
        Map rawParams = this.extractFieldParameterTags(javaClass);
        Iterator it = rawParams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JavaField field = (JavaField)entry.getValue();
            Type type = field.getType();
            Parameter pd = new Parameter();
            if (!type.isArray()) {
                pd.setType(type.getValue());
            } else {
                StringBuffer value = new StringBuffer(type.getValue());
                int remaining = type.getDimensions();
                while (remaining-- > 0) {
                    value.append("[]");
                }
                pd.setType(value.toString());
            }
            pd.setDescription(field.getComment());
            DocletTag componentTag = field.getTagByName(COMPONENT);
            if (componentTag != null) {
                String roleHint;
                String role = componentTag.getNamedParameter(COMPONENT_ROLE);
                if (role == null) {
                    role = field.getType().toString();
                }
                if ((roleHint = componentTag.getNamedParameter(COMPONENT_ROLEHINT)) == null) {
                    roleHint = componentTag.getNamedParameter("role-hint");
                }
                pd.setRequirement(new Requirement(role, roleHint));
                pd.setName((String)entry.getKey());
                pd.setEditable(false);
            } else {
                String alias;
                DocletTag sinceTag;
                DocletTag parameter = field.getTagByName(PARAMETER);
                String property = parameter.getNamedParameter(PARAMETER_PROPERTY);
                if (!StringUtils.isEmpty((String)property)) {
                    pd.setName(property);
                } else {
                    pd.setName((String)entry.getKey());
                }
                pd.setRequired(field.getTagByName(REQUIRED) != null);
                pd.setEditable(field.getTagByName(READONLY) == null);
                DocletTag deprecationTag = field.getTagByName(DEPRECATED);
                if (deprecationTag != null) {
                    pd.setDeprecated(deprecationTag.getValue());
                }
                if ((sinceTag = field.getTagByName(SINCE)) != null) {
                    pd.setSince(sinceTag.getValue());
                }
                if (!StringUtils.isEmpty((String)(alias = parameter.getNamedParameter(PARAMETER_ALIAS)))) {
                    pd.setAlias(alias);
                }
                pd.setExpression(parameter.getNamedParameter(PARAMETER_EXPRESSION));
                if ("${reports}".equals(pd.getExpression())) {
                    mojoDescriptor.setRequiresReports(true);
                }
                pd.setDefaultValue(parameter.getNamedParameter(PARAMETER_DEFAULT_VALUE));
                pd.setImplementation(parameter.getNamedParameter(PARAMETER_IMPLEMENTATION));
            }
            mojoDescriptor.addParameter(pd);
        }
    }

    private Map extractFieldParameterTags(JavaClass javaClass) {
        JavaClass superClass = javaClass.getSuperJavaClass();
        TreeMap<String, JavaField> rawParams = superClass != null ? this.extractFieldParameterTags(superClass) : new TreeMap<String, JavaField>();
        JavaField[] classFields = javaClass.getFields();
        if (classFields != null) {
            for (int i = 0; i < classFields.length; ++i) {
                JavaField field = classFields[i];
                if (field.getTagByName(PARAMETER) == null && field.getTagByName(COMPONENT) == null) continue;
                rawParams.put(field.getName(), field);
            }
        }
        return rawParams;
    }

    public List execute(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        JavaClass[] javaClasses = this.discoverClasses(project);
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        for (int i = 0; i < javaClasses.length; ++i) {
            DocletTag tag = javaClasses[i].getTagByName("goal");
            if (tag == null) continue;
            MojoDescriptor mojoDescriptor = this.createMojoDescriptor(javaClasses[i]);
            mojoDescriptor.setPluginDescriptor(pluginDescriptor);
            this.validate(mojoDescriptor);
            descriptors.add(mojoDescriptor);
        }
        return descriptors;
    }

    protected JavaClass[] discoverClasses(MavenProject project) {
        JavaDocBuilder builder = new JavaDocBuilder();
        Iterator i = project.getCompileSourceRoots().iterator();
        while (i.hasNext()) {
            builder.addSourceTree(new File((String)i.next()));
        }
        if (!project.getCompileSourceRoots().contains(new File(project.getBasedir(), "target/generated-sources/plugin").getAbsolutePath())) {
            builder.addSourceTree(new File(project.getBasedir(), "target/generated-sources/plugin"));
        }
        return builder.getClasses();
    }

    protected void validate(MojoDescriptor mojoDescriptor) throws InvalidParameterException {
        List parameters = mojoDescriptor.getParameters();
        if (parameters != null) {
            for (int j = 0; j < parameters.size(); ++j) {
                this.validateParameter((Parameter)parameters.get(j), j);
            }
        }
    }
}

