/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.cli.AbstractMavenTransferListener;
import org.apache.maven.repository.ArtifactTransferEvent;
import org.apache.maven.repository.ArtifactTransferResource;

class ConsoleMavenTransferListener
extends AbstractMavenTransferListener {
    private Map<ArtifactTransferResource, Long> downloads = new ConcurrentHashMap<ArtifactTransferResource, Long>();
    private int lastLength;

    public ConsoleMavenTransferListener(PrintStream out) {
        super(out);
    }

    protected void doProgress(ArtifactTransferEvent transferEvent) {
        ArtifactTransferResource resource = transferEvent.getResource();
        this.downloads.put(resource, transferEvent.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(64);
        for (Map.Entry<ArtifactTransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            buffer.append(this.getStatus(complete, total)).append("  ");
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        this.out.print(buffer);
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    public void transferCompleted(ArtifactTransferEvent transferEvent) {
        this.downloads.remove(transferEvent.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength);
        buffer.append('\r');
        this.out.print(buffer);
        super.transferCompleted(transferEvent);
    }
}

