/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.docbook;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.module.docbook.DocbookMarkup;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DocBookParser
extends AbstractXmlParser
implements DocbookMarkup {
    private int level = -1;
    private boolean isBold;
    private Stack parent = new Stack();
    private Collection failedElements = new HashSet();
    private static final Collection HIER_ELEMENTS = new HashSet();
    private static final Collection VERBATIM_ELEMENTS = new HashSet();
    private static final Collection BOLD_ELEMENTS = new HashSet();
    private static final Collection ITALIC_ELEMENTS = new HashSet();
    private static final Collection MONOSPACE_ELEMENTS = new HashSet();

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        String id = this.getAttributeValue(parser, HTML.Attribute.ID.toString());
        if (id != null) {
            sink.anchor(id);
            sink.anchor_();
        }
        if (HIER_ELEMENTS.contains(parser.getName())) {
            ++this.level;
            if (this.level == 0) {
                sink.body();
            } else if (this.level == 1) {
                sink.section1();
            } else if (this.level == 2) {
                sink.section2();
            } else if (this.level == 3) {
                sink.section3();
            } else if (this.level == 4) {
                sink.section4();
            } else if (this.level == 5) {
                sink.section5();
            }
        } else if (parser.getName().endsWith(INFO_TAG.toString()) && this.level == 0) {
            sink.head();
            this.parent.push(parser.getName());
        } else if (parser.getName().equals(ITEMIZEDLIST_TAG.toString())) {
            sink.list();
            this.parent.push(parser.getName());
        } else if (parser.getName().equals(ORDEREDLIST_TAG.toString())) {
            int numeration = 0;
            String style = this.getAttributeValue(parser, "numeration");
            if (style.equals("arabic")) {
                numeration = 0;
            } else if (style.equals("loweralpha")) {
                numeration = 1;
            } else if (style.equals("lowerroman")) {
                numeration = 3;
            } else if (style.equals("upperalpha")) {
                numeration = 2;
            } else if (style.equals("upperroman")) {
                numeration = 4;
            }
            sink.numberedList(numeration);
            this.parent.push(parser.getName());
        } else if (parser.getName().equals(LISTITEM_TAG.toString())) {
            if (this.isParent(VARIABLELIST_TAG.toString())) {
                sink.definition();
            } else if (this.isParent(ORDEREDLIST_TAG.toString())) {
                sink.numberedListItem();
            } else {
                sink.listItem();
            }
        } else if (parser.getName().equals(VARIABLELIST_TAG.toString())) {
            sink.definitionList();
            this.parent.push(parser.getName());
        } else if (parser.getName().equals(VARLISTENTRY_TAG.toString())) {
            sink.definitionListItem();
        } else if (parser.getName().equals(TERM_TAG.toString())) {
            sink.definedTerm();
        } else if (parser.getName().equals(FIGURE_TAG.toString()) || parser.getName().equals(INFORMALFIGURE_TAG.toString())) {
            sink.figure();
            this.parent.push(parser.getName());
        } else if (parser.getName().equals(IMAGEOBJECT_TAG.toString())) {
            String fileref = this.getAttributeValue(parser, "fileref");
            if (fileref != null) {
                sink.figureGraphics(fileref);
                this.parent.push(parser.getName());
            }
        } else if (parser.getName().equals(HTML.Tag.CAPTION.toString()) && this.isParent(FIGURE_TAG.toString())) {
            sink.figureCaption();
        } else if (parser.getName().equals(HTML.Tag.TABLE.toString()) || parser.getName().equals(INFORMALTABLE_TAG.toString())) {
            sink.table();
            this.parent.push(parser.getName());
        } else if (parser.getName().equals(THEAD_TAG.toString())) {
            this.parent.push(parser.getName());
        } else if (parser.getName().equals(HTML.Tag.TR.toString()) || parser.getName().equals(ROW_TAG.toString())) {
            sink.tableRow();
        } else if (parser.getName().equals(ENTRY_TAG.toString()) && this.isParent(THEAD_TAG.toString()) || parser.getName().equals(HTML.Tag.TH.toString())) {
            sink.tableHeaderCell();
        } else if (parser.getName().equals(ENTRY_TAG.toString())) {
            sink.tableCell();
        } else if (parser.getName().equals(HTML.Tag.CAPTION.toString()) && (this.isParent(INFORMALTABLE_TAG.toString()) || this.isParent(HTML.Tag.TABLE.toString()))) {
            sink.tableCaption();
        } else if ((parser.getName().equals(PARA_TAG.toString()) || parser.getName().equals(SIMPARA_TAG.toString())) && !this.isParent(FORMALPARA_TAG.toString())) {
            sink.paragraph();
        } else if (parser.getName().equals(FORMALPARA_TAG.toString())) {
            this.parent.push(parser.getName());
            sink.paragraph();
        } else if (parser.getName().equals(HTML.Tag.TITLE.toString()) && this.isParent(FORMALPARA_TAG.toString())) {
            sink.bold();
        } else if (VERBATIM_ELEMENTS.contains(parser.getName())) {
            sink.verbatim(SinkEventAttributeSet.BOXED);
        } else if (BOLD_ELEMENTS.contains(parser.getName()) && MONOSPACE_ELEMENTS.contains(parser.getName())) {
            sink.bold();
            sink.monospaced();
        } else if (ITALIC_ELEMENTS.contains(parser.getName()) && MONOSPACE_ELEMENTS.contains(parser.getName())) {
            sink.italic();
            sink.monospaced();
        } else if (BOLD_ELEMENTS.contains(parser.getName())) {
            sink.bold();
        } else if (ITALIC_ELEMENTS.contains(parser.getName()) && "bold".equals(parser.getAttributeValue(null, "role"))) {
            sink.bold();
            this.isBold = true;
        } else if (ITALIC_ELEMENTS.contains(parser.getName())) {
            sink.italic();
        } else if (MONOSPACE_ELEMENTS.contains(parser.getName())) {
            sink.monospaced();
        } else if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
            if (parser.getName().equals(FIGURE_TAG.toString()) || parser.getName().equals(INFORMALFIGURE_TAG.toString())) {
                sink.figureCaption();
            } else if (parser.getName().equals(HTML.Tag.TABLE.toString()) || parser.getName().equals(INFORMALTABLE_TAG.toString())) {
                sink.tableCaption();
            } else if (this.level == 0) {
                sink.title();
            } else if (this.level == 1) {
                sink.sectionTitle1();
            } else if (this.level == 2) {
                sink.sectionTitle2();
            } else if (this.level == 3) {
                sink.sectionTitle3();
            } else if (this.level == 4) {
                sink.sectionTitle4();
            } else if (this.level == 5) {
                sink.sectionTitle5();
            }
        } else if (parser.getName().equals(CORPAUTHOR_TAG.toString())) {
            sink.author();
        } else if (parser.getName().equals(DATE_TAG.toString())) {
            sink.date();
        } else if (parser.getName().equals(ULINK_TAG.toString())) {
            String url = this.getAttributeValue(parser, URL_TAG.toString());
            if (url != null) {
                this.parent.push(parser.getName());
                sink.link(url);
            }
        } else if (parser.getName().equals(EMAIL_TAG.toString())) {
            String mailto;
            try {
                mailto = parser.nextText();
            }
            catch (IOException e) {
                throw new XmlPullParserException("IOException: " + e.getMessage(), parser, (Throwable)e);
            }
            sink.link("mailto:" + mailto);
            sink.link_();
        } else if (parser.getName().equals(LINK_TAG.toString())) {
            String linkend = this.getAttributeValue(parser, "linkend");
            if (linkend != null) {
                this.parent.push(parser.getName());
                sink.link("#" + linkend);
            }
        } else if (parser.getName().equals(XREF_TAG.toString())) {
            String linkend = this.getAttributeValue(parser, "linkend");
            if (linkend != null) {
                sink.link("#" + linkend);
                sink.text("Link");
                sink.link_();
            }
        } else {
            this.failedElements.add(parser.getName());
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (HIER_ELEMENTS.contains(parser.getName())) {
            if (this.level == 0) {
                sink.body_();
            } else if (this.level == 1) {
                sink.section1_();
            } else if (this.level == 2) {
                sink.section2_();
            } else if (this.level == 3) {
                sink.section3_();
            } else if (this.level == 4) {
                sink.section4_();
            } else if (this.level == 5) {
                sink.section5_();
            }
            --this.level;
        } else if (parser.getName().endsWith(INFO_TAG.toString()) && this.level == 0) {
            sink.head_();
            this.parent.pop();
        } else if (parser.getName().equals(ITEMIZEDLIST_TAG.toString())) {
            sink.list_();
            this.parent.pop();
        } else if (parser.getName().equals(ORDEREDLIST_TAG.toString())) {
            sink.numberedList_();
            this.parent.pop();
        } else if (parser.getName().equals(LISTITEM_TAG.toString())) {
            if (this.isParent(VARIABLELIST_TAG.toString())) {
                sink.definition_();
            } else if (this.isParent(ORDEREDLIST_TAG.toString())) {
                sink.numberedListItem_();
            } else {
                sink.listItem_();
            }
        } else if (parser.getName().equals(VARIABLELIST_TAG.toString())) {
            sink.definitionList_();
        } else if (parser.getName().equals(VARLISTENTRY_TAG.toString())) {
            sink.definitionListItem_();
        } else if (parser.getName().equals(TERM_TAG.toString())) {
            sink.definedTerm_();
        } else if (parser.getName().equals(FIGURE_TAG.toString()) || parser.getName().equals(INFORMALFIGURE_TAG.toString())) {
            sink.figure_();
            this.parent.pop();
        } else if (parser.getName().equals(HTML.Tag.CAPTION.toString()) && this.isParent(FIGURE_TAG.toString())) {
            sink.figureCaption_();
        } else if (parser.getName().equals(HTML.Tag.TABLE.toString()) || parser.getName().equals(INFORMALTABLE_TAG.toString())) {
            sink.table_();
            this.parent.pop();
        } else if (parser.getName().equals(THEAD_TAG.toString())) {
            this.parent.pop();
        } else if (parser.getName().equals(HTML.Tag.TR.toString()) || parser.getName().equals(ROW_TAG.toString())) {
            sink.tableRow_();
        } else if (parser.getName().equals(ENTRY_TAG.toString()) && this.isParent(THEAD_TAG.toString()) || parser.getName().equals(HTML.Tag.TH.toString())) {
            sink.tableHeaderCell_();
        } else if (parser.getName().equals(ENTRY_TAG.toString())) {
            sink.tableCell_();
        } else if (parser.getName().equals(HTML.Tag.CAPTION.toString()) && (this.isParent(INFORMALTABLE_TAG.toString()) || this.isParent(HTML.Tag.TABLE.toString()))) {
            sink.tableCaption_();
        } else if ((parser.getName().equals(PARA_TAG.toString()) || parser.getName().equals(SIMPARA_TAG.toString())) && !this.isParent(FORMALPARA_TAG.toString())) {
            sink.paragraph_();
        } else if (parser.getName().equals(FORMALPARA_TAG.toString())) {
            this.parent.pop();
            sink.paragraph_();
        } else if (parser.getName().equals(HTML.Tag.TITLE.toString()) && this.isParent(FORMALPARA_TAG.toString())) {
            sink.text(". ");
            sink.bold_();
        } else if (VERBATIM_ELEMENTS.contains(parser.getName())) {
            sink.verbatim_();
        } else if (BOLD_ELEMENTS.contains(parser.getName()) && MONOSPACE_ELEMENTS.contains(parser.getName())) {
            sink.bold_();
            sink.monospaced_();
        } else if (ITALIC_ELEMENTS.contains(parser.getName()) && MONOSPACE_ELEMENTS.contains(parser.getName())) {
            sink.italic_();
            sink.monospaced_();
        } else if (BOLD_ELEMENTS.contains(parser.getName())) {
            sink.bold_();
        } else if (ITALIC_ELEMENTS.contains(parser.getName())) {
            if (this.isBold) {
                sink.bold_();
                this.isBold = false;
            } else {
                sink.italic_();
            }
        } else if (MONOSPACE_ELEMENTS.contains(parser.getName())) {
            sink.monospaced_();
        } else if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
            if (parser.getName().equals(FIGURE_TAG.toString()) || parser.getName().equals(INFORMALFIGURE_TAG.toString())) {
                sink.figureCaption_();
            } else if (parser.getName().equals(HTML.Tag.TABLE.toString()) || parser.getName().equals(INFORMALTABLE_TAG.toString())) {
                sink.tableCaption_();
            } else if (this.level == 0) {
                sink.title_();
            } else if (this.level == 1) {
                sink.sectionTitle1_();
            } else if (this.level == 2) {
                sink.sectionTitle2_();
            } else if (this.level == 3) {
                sink.sectionTitle3_();
            } else if (this.level == 4) {
                sink.sectionTitle4_();
            } else if (this.level == 5) {
                sink.sectionTitle5_();
            }
        } else if (parser.getName().equals(CORPAUTHOR_TAG.toString())) {
            sink.author_();
        } else if (parser.getName().equals(DATE_TAG.toString())) {
            sink.date_();
        } else if ((parser.getName().equals(ULINK_TAG.toString()) || parser.getName().equals(LINK_TAG.toString())) && this.isParent(parser.getName())) {
            this.parent.pop();
            sink.link_();
        }
    }

    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = parser.getText();
        if (StringUtils.isNotEmpty((String)text)) {
            String[] lines = text.split("\n", -1);
            for (int i = 0; i < lines.length - 1; ++i) {
                sink.text(lines[i] + EOL);
            }
            if (lines[lines.length - 1].length() > 0) {
                sink.text(lines[lines.length - 1]);
            }
        }
    }

    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = parser.getText();
        sink.rawText(text);
    }

    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = parser.getText();
        if ("PB".equals(text.trim())) {
            sink.pageBreak();
        } else if ("HR".equals(text.trim())) {
            sink.horizontalRule();
        } else if ("LB".equals(text.trim())) {
            sink.lineBreak();
        } else {
            sink.comment(text.trim());
        }
    }

    protected void handleEntity(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = parser.getText();
        int[] holder = new int[]{0, 0};
        char[] chars = parser.getTextCharacters(holder);
        String textChars = String.valueOf(chars, holder[0], holder[1]);
        if ("#x00A0".equals(textChars)) {
            sink.nonBreakingSpace();
        } else {
            sink.text(text);
        }
    }

    public boolean isValidate() {
        return false;
    }

    private String getAttributeValue(XmlPullParser parser, String name) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeName(i).equals(name)) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }

    private boolean isParent(String element) {
        if (this.parent.size() > 0) {
            return this.parent.peek().equals(element);
        }
        return false;
    }

    static {
        HIER_ELEMENTS.add("set");
        HIER_ELEMENTS.add("book");
        HIER_ELEMENTS.add("part");
        HIER_ELEMENTS.add("chapter");
        HIER_ELEMENTS.add("section");
        HIER_ELEMENTS.add("sect1");
        HIER_ELEMENTS.add("sect2");
        HIER_ELEMENTS.add("sect3");
        HIER_ELEMENTS.add("sect4");
        HIER_ELEMENTS.add("sect5");
        HIER_ELEMENTS.add("article");
        HIER_ELEMENTS.add("preface");
        HIER_ELEMENTS.add("partintro");
        HIER_ELEMENTS.add("appendix");
        HIER_ELEMENTS.add("bibliography");
        HIER_ELEMENTS.add("reference");
        HIER_ELEMENTS.add("bibliography");
        HIER_ELEMENTS.add("bibliodiv");
        HIER_ELEMENTS.add("glossary");
        HIER_ELEMENTS.add("refentry");
        HIER_ELEMENTS.add("refnamediv");
        HIER_ELEMENTS.add("refsection");
        HIER_ELEMENTS.add("refsect1");
        HIER_ELEMENTS.add("refsect2");
        HIER_ELEMENTS.add("refsect3");
        VERBATIM_ELEMENTS.add("programlisting");
        VERBATIM_ELEMENTS.add("screen");
        VERBATIM_ELEMENTS.add("literallayout");
        VERBATIM_ELEMENTS.add("synopsis");
        BOLD_ELEMENTS.add("command");
        BOLD_ELEMENTS.add("keycap");
        BOLD_ELEMENTS.add("shortcut");
        BOLD_ELEMENTS.add("userinput");
        ITALIC_ELEMENTS.add("parameter");
        ITALIC_ELEMENTS.add("replaceable");
        ITALIC_ELEMENTS.add("medialabel");
        ITALIC_ELEMENTS.add("structfield");
        ITALIC_ELEMENTS.add("systemitem");
        ITALIC_ELEMENTS.add("citetitle");
        ITALIC_ELEMENTS.add("emphasis");
        ITALIC_ELEMENTS.add("foreignphrase");
        ITALIC_ELEMENTS.add("wordasword");
        MONOSPACE_ELEMENTS.add("classname");
        MONOSPACE_ELEMENTS.add("exceptionname");
        MONOSPACE_ELEMENTS.add("interfacename");
        MONOSPACE_ELEMENTS.add("methodname");
        MONOSPACE_ELEMENTS.add("computeroutput");
        MONOSPACE_ELEMENTS.add("constant");
        MONOSPACE_ELEMENTS.add("envar");
        MONOSPACE_ELEMENTS.add("function");
        MONOSPACE_ELEMENTS.add("parameter");
        MONOSPACE_ELEMENTS.add("replaceable");
        MONOSPACE_ELEMENTS.add("literal");
        MONOSPACE_ELEMENTS.add("code");
        MONOSPACE_ELEMENTS.add("option");
        MONOSPACE_ELEMENTS.add("prompt");
        MONOSPACE_ELEMENTS.add("structfield");
        MONOSPACE_ELEMENTS.add("systemitem");
        MONOSPACE_ELEMENTS.add("structfield");
        MONOSPACE_ELEMENTS.add("userinput");
        MONOSPACE_ELEMENTS.add("varname");
        MONOSPACE_ELEMENTS.add("sgmltag");
        MONOSPACE_ELEMENTS.add("tag");
        MONOSPACE_ELEMENTS.add("uri");
        MONOSPACE_ELEMENTS.add("filename");
    }
}

