/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.option.HelpLineImpl;
import org.apache.commons.cli2.option.OptionImpl;
import org.apache.commons.cli2.resource.ResourceHelper;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;

public class ArgumentImpl
extends OptionImpl
implements Argument {
    private static final char NUL = '\u0000';
    public static final char DEFAULT_INITIAL_SEPARATOR = '\u0000';
    public static final char DEFAULT_SUBSEQUENT_SEPARATOR = '\u0000';
    public static final String DEFAULT_CONSUME_REMAINING = "--";
    private final String name;
    private final String description;
    private final int minimum;
    private final int maximum;
    private final char initialSeparator;
    private final char subsequentSeparator;
    private final boolean subsequentSplit;
    private final Validator validator;
    private final String consumeRemaining;
    private final List defaultValues;
    private final ResourceHelper resources = ResourceHelper.getResourceHelper();

    public ArgumentImpl(String name, String description, int minimum, int maximum, char initialSeparator, char subsequentSeparator, Validator validator, String consumeRemaining, List valueDefaults, int id) {
        super(id, false);
        this.name = name == null ? "arg" : name;
        this.description = description;
        this.minimum = minimum;
        this.maximum = maximum;
        this.initialSeparator = initialSeparator;
        this.subsequentSeparator = subsequentSeparator;
        this.subsequentSplit = subsequentSeparator != '\u0000';
        this.validator = validator;
        this.consumeRemaining = consumeRemaining;
        this.defaultValues = valueDefaults;
        if (minimum > maximum) {
            throw new IllegalArgumentException(this.resources.getMessage("Argument.minimum.exceeds.maximum"));
        }
        if (valueDefaults != null && valueDefaults.size() > 0) {
            if (valueDefaults.size() < minimum) {
                throw new IllegalArgumentException(this.resources.getMessage("Argument.too.few.defaults"));
            }
            if (valueDefaults.size() > maximum) {
                throw new IllegalArgumentException(this.resources.getMessage("Argument.too.many.defaults"));
            }
        }
    }

    public String getPreferredName() {
        return this.name;
    }

    public void processValues(WriteableCommandLine commandLine, ListIterator arguments, Option option) throws OptionException {
        int argumentCount = commandLine.getUndefaultedValues(option).size();
        while (arguments.hasNext() && argumentCount < this.maximum) {
            String allValuesQuoted = (String)arguments.next();
            String allValues = this.stripBoundaryQuotes(allValuesQuoted);
            if (allValuesQuoted.equals(this.consumeRemaining)) {
                while (arguments.hasNext() && argumentCount < this.maximum) {
                    ++argumentCount;
                    commandLine.addValue(option, arguments.next());
                }
                continue;
            }
            if (commandLine.looksLikeOption(allValuesQuoted)) {
                arguments.previous();
                break;
            }
            if (this.subsequentSplit) {
                StringTokenizer values = new StringTokenizer(allValues, String.valueOf(this.subsequentSeparator));
                arguments.remove();
                while (values.hasMoreTokens() && argumentCount < this.maximum) {
                    ++argumentCount;
                    String token = values.nextToken();
                    commandLine.addValue(option, token);
                    arguments.add(token);
                }
                if (!values.hasMoreTokens()) continue;
                throw new OptionException(option, "Argument.unexpected.value", values.nextToken());
            }
            ++argumentCount;
            commandLine.addValue(option, allValues);
        }
    }

    public boolean canProcess(WriteableCommandLine commandLine, String arg) {
        return true;
    }

    public Set getPrefixes() {
        return Collections.EMPTY_SET;
    }

    public void process(WriteableCommandLine commandLine, ListIterator args) throws OptionException {
        this.processValues(commandLine, args, this);
    }

    public char getInitialSeparator() {
        return this.initialSeparator;
    }

    public char getSubsequentSeparator() {
        return this.subsequentSeparator;
    }

    public Set getTriggers() {
        return Collections.EMPTY_SET;
    }

    public String getConsumeRemaining() {
        return this.consumeRemaining;
    }

    public List getDefaultValues() {
        return this.defaultValues;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void validate(WriteableCommandLine commandLine) throws OptionException {
        this.validate(commandLine, this);
    }

    public void validate(WriteableCommandLine commandLine, Option option) throws OptionException {
        List values = commandLine.getValues(option);
        if (values.size() < this.minimum) {
            throw new OptionException(option, "Argument.missing.values");
        }
        if (values.size() > this.maximum) {
            throw new OptionException(option, "Argument.unexpected.value", (String)values.get(this.maximum));
        }
        if (this.validator != null) {
            try {
                this.validator.validate(values);
            }
            catch (InvalidArgumentException ive) {
                throw new OptionException(option, "Argument.unexpected.value", ive.getMessage());
            }
        }
    }

    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp) {
        boolean optional = helpSettings.contains(DisplaySetting.DISPLAY_OPTIONAL);
        boolean numbered = this.maximum > 1 && helpSettings.contains(DisplaySetting.DISPLAY_ARGUMENT_NUMBERED);
        boolean bracketed = helpSettings.contains(DisplaySetting.DISPLAY_ARGUMENT_BRACKETED);
        int max = this.maximum == Integer.MAX_VALUE ? 2 : this.maximum;
        int i = 0;
        while (i < max) {
            if (i > 0) {
                buffer.append(' ');
            }
            if (i >= this.minimum && (optional || i > 0)) {
                buffer.append('[');
            }
            if (bracketed) {
                buffer.append('<');
            }
            buffer.append(this.name);
            ++i;
            if (numbered) {
                buffer.append(i);
            }
            if (!bracketed) continue;
            buffer.append('>');
        }
        if (this.maximum == Integer.MAX_VALUE) {
            buffer.append(" ...");
        }
        while (i > 0) {
            if (--i < this.minimum || !optional && i <= 0) continue;
            buffer.append(']');
        }
    }

    public String getDescription() {
        return this.description;
    }

    public List helpLines(int depth, Set helpSettings, Comparator comp) {
        HelpLineImpl helpLine = new HelpLineImpl(this, depth);
        return Collections.singletonList(helpLine);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public String stripBoundaryQuotes(String token) {
        if (!token.startsWith("\"") || !token.endsWith("\"")) {
            return token;
        }
        token = token.substring(1, token.length() - 1);
        return token;
    }

    public boolean isRequired() {
        return this.getMinimum() > 0;
    }

    public void defaults(WriteableCommandLine commandLine) {
        super.defaults(commandLine);
        this.defaultValues(commandLine, this);
    }

    public void defaultValues(WriteableCommandLine commandLine, Option option) {
        commandLine.setDefaultValues(option, this.defaultValues);
    }
}

