/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.message.ParameterizedMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadContext {
    public static final Map<String, String> EMPTY_MAP = new ImmutableMap();
    public static final ContextStack EMPTY_STACK = new ImmutableStack();
    private static final String DISABLE_MAP = "disableThreadContextMap";
    private static final String DISABLE_STACK = "disableThreadContextStack";
    private static final String DISABLE_ALL = "disableThreadContext";
    private static boolean all = Boolean.getBoolean("disableThreadContext");
    private static boolean useMap = !Boolean.getBoolean("disableThreadContextMap") && !all;
    private static boolean useStack = !Boolean.getBoolean("disableThreadContextStack") && !all;
    private static ThreadLocal<Map<String, String>> localMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> childValue(Map<String, String> parentValue) {
            return parentValue == null || !useMap ? null : new HashMap<String, String>(parentValue);
        }
    };
    private static ThreadLocal<ContextStack> localStack = new ThreadLocal();

    private ThreadContext() {
    }

    public static void put(String key, String value) {
        if (!useMap) {
            return;
        }
        Map<String, String> map = localMap.get();
        if (map == null) {
            map = new HashMap<String, String>();
            localMap.set(map);
        }
        map.put(key, value);
    }

    public static String get(String key) {
        Map<String, String> map = localMap.get();
        return map == null ? null : map.get(key);
    }

    public static void remove(String key) {
        Map<String, String> map = localMap.get();
        if (map != null) {
            map.remove(key);
        }
    }

    public static void clear() {
        localMap.remove();
    }

    public static boolean containsKey(String key) {
        Map<String, String> map = localMap.get();
        return map == null ? false : map.containsKey(key);
    }

    public static Map<String, String> getContext() {
        Map<String, String> map = localMap.get();
        return map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
    }

    public static Map<String, String> getImmutableContext() {
        Map<String, String> map = localMap.get();
        return map == null ? new ImmutableMap() : new ImmutableMap(map);
    }

    public static boolean isEmpty() {
        Map<String, String> map = localMap.get();
        return map == null || map.size() == 0;
    }

    public static void clearStack() {
        localStack.remove();
    }

    public static ContextStack cloneStack() {
        ContextStack stack = localStack.get();
        return stack == null ? new ThreadContextStack() : new ThreadContextStack((Collection<String>)stack.asList());
    }

    public static ContextStack getImmutableStack() {
        ContextStack stack = localStack.get();
        return stack == null ? EMPTY_STACK : new ImmutableStack((Collection<String>)stack.asList());
    }

    public static void setStack(Collection<String> stack) {
        if (stack.size() == 0 || !useStack) {
            return;
        }
        localStack.set(new ThreadContextStack(stack));
    }

    public static int getDepth() {
        ContextStack stack = localStack.get();
        return stack == null ? 0 : stack.getDepth();
    }

    public static String pop() {
        ContextStack s = localStack.get();
        if (s == null || s.getDepth() == 0) {
            return "";
        }
        return s.pop();
    }

    public static String peek() {
        ContextStack s = localStack.get();
        if (s == null || s.getDepth() == 0) {
            return "";
        }
        return s.peek();
    }

    public static void push(String message) {
        if (!useStack) {
            return;
        }
        ContextStack stack = localStack.get();
        if (stack == null) {
            stack = new ThreadContextStack();
            localStack.set(stack);
        }
        stack.push(message);
    }

    public static void push(String message, Object ... args) {
        if (!useStack) {
            return;
        }
        ContextStack stack = localStack.get();
        if (stack == null) {
            stack = new ThreadContextStack();
            localStack.set(stack);
        }
        stack.push(ParameterizedMessage.format(message, args));
    }

    public static void removeStack() {
        localStack.remove();
    }

    public static void trim(int depth) {
        ContextStack stack = localStack.get();
        if (stack != null) {
            stack.trim(depth);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = 5050503L;

        public ImmutableMap() {
        }

        public ImmutableMap(Map<String, String> map) {
            super(map);
        }

        @Override
        public String put(String s, String s1) {
            throw new UnsupportedOperationException("Map cannot be modified");
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map) {
            throw new UnsupportedOperationException("Map cannot be modified");
        }

        @Override
        public String remove(Object o) {
            throw new UnsupportedOperationException("Map cannot be modified");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Map cannot be modified");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableStack
    extends ThreadContextStack {
        private static final long serialVersionUID = 5050502L;

        public ImmutableStack() {
        }

        public ImmutableStack(Collection<String> collection) {
            super(collection);
        }

        public ImmutableStack(ThreadContextStack stack) {
            super(stack);
        }

        @Override
        public void push(String message) {
            throw new UnsupportedOperationException("Stack cannot be modified");
        }

        @Override
        public void trim(int depth) {
            throw new UnsupportedOperationException("Stack cannot be modified");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadContextStack
    extends ArrayList<String>
    implements ContextStack {
        private static final long serialVersionUID = 5050501L;

        public ThreadContextStack() {
        }

        public ThreadContextStack(Collection<String> collection) {
            super(collection);
        }

        @Override
        public String pop() {
            int index = this.size() - 1;
            if (index >= 0) {
                String result = (String)this.get(index);
                this.remove(index);
                return result;
            }
            throw new NoSuchElementException("The ThreadContext stack is empty");
        }

        @Override
        public String peek() {
            int index = this.size() - 1;
            if (index >= 0) {
                return (String)this.get(index);
            }
            return null;
        }

        @Override
        public void push(String message) {
            this.add(message);
        }

        @Override
        public int getDepth() {
            return this.size();
        }

        @Override
        public List<String> asList() {
            return this;
        }

        @Override
        public void trim(int depth) {
            if (depth < 0) {
                throw new IllegalArgumentException("Maximum stack depth cannot be negative");
            }
            while (this.size() > depth) {
                this.remove(this.size() - 1);
            }
        }

        @Override
        public ContextStack copy() {
            return new ThreadContextStack(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ContextStack
    extends Serializable {
        public void clear();

        public String pop();

        public String peek();

        public void push(String var1);

        public int getDepth();

        public List<String> asList();

        public void trim(int var1);

        public ContextStack copy();
    }
}

