/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.ddf.EscherProperties;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherArrayProperty
extends EscherComplexProperty {
    private static final int FIXED_SIZE = 6;
    private boolean sizeIncludesHeaderSize = true;
    private boolean emptyComplexPart = false;

    public EscherArrayProperty(short id, byte[] complexData) {
        super(id, EscherArrayProperty.checkComplexData(complexData));
        this.emptyComplexPart = complexData.length == 0;
    }

    public EscherArrayProperty(short propertyNumber, boolean isBlipId, byte[] complexData) {
        super(propertyNumber, isBlipId, EscherArrayProperty.checkComplexData(complexData));
    }

    private static byte[] checkComplexData(byte[] complexData) {
        if (complexData == null || complexData.length == 0) {
            complexData = new byte[6];
        }
        return complexData;
    }

    public int getNumberOfElementsInArray() {
        return LittleEndian.getUShort(this.complexData, 0);
    }

    public void setNumberOfElementsInArray(int numberOfElements) {
        int expectedArraySize = numberOfElements * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (expectedArraySize != this.complexData.length) {
            byte[] newArray = new byte[expectedArraySize];
            System.arraycopy(this.complexData, 0, newArray, 0, this.complexData.length);
            this.complexData = newArray;
        }
        LittleEndian.putShort(this.complexData, 0, (short)numberOfElements);
    }

    public int getNumberOfElementsInMemory() {
        return LittleEndian.getUShort(this.complexData, 2);
    }

    public void setNumberOfElementsInMemory(int numberOfElements) {
        int expectedArraySize = numberOfElements * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (expectedArraySize != this.complexData.length) {
            byte[] newArray = new byte[expectedArraySize];
            System.arraycopy(this.complexData, 0, newArray, 0, expectedArraySize);
            this.complexData = newArray;
        }
        LittleEndian.putShort(this.complexData, 2, (short)numberOfElements);
    }

    public short getSizeOfElements() {
        return LittleEndian.getShort(this.complexData, 4);
    }

    public void setSizeOfElements(int sizeOfElements) {
        LittleEndian.putShort(this.complexData, 4, (short)sizeOfElements);
        int expectedArraySize = this.getNumberOfElementsInArray() * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (expectedArraySize != this.complexData.length) {
            byte[] newArray = new byte[expectedArraySize];
            System.arraycopy(this.complexData, 0, newArray, 0, 6);
            this.complexData = newArray;
        }
    }

    public byte[] getElement(int index) {
        int actualSize = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        byte[] result = new byte[actualSize];
        System.arraycopy(this.complexData, 6 + index * actualSize, result, 0, result.length);
        return result;
    }

    public void setElement(int index, byte[] element) {
        int actualSize = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        System.arraycopy(element, 0, this.complexData, 6 + index * actualSize, actualSize);
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer results = new StringBuffer();
        results.append("    {EscherArrayProperty:" + nl);
        results.append("     Num Elements: " + this.getNumberOfElementsInArray() + nl);
        results.append("     Num Elements In Memory: " + this.getNumberOfElementsInMemory() + nl);
        results.append("     Size of elements: " + this.getSizeOfElements() + nl);
        for (int i = 0; i < this.getNumberOfElementsInArray(); ++i) {
            results.append("     Element " + i + ": " + HexDump.toHex(this.getElement(i)) + nl);
        }
        results.append("}" + nl);
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + nl + results.toString();
    }

    public int setArrayData(byte[] data, int offset) {
        if (this.emptyComplexPart) {
            this.complexData = new byte[0];
        } else {
            short numElements = LittleEndian.getShort(data, offset);
            short numReserved = LittleEndian.getShort(data, offset + 2);
            short sizeOfElements = LittleEndian.getShort(data, offset + 4);
            int arraySize = EscherArrayProperty.getActualSizeOfElements(sizeOfElements) * numElements;
            if (arraySize == this.complexData.length) {
                this.complexData = new byte[arraySize + 6];
                this.sizeIncludesHeaderSize = false;
            }
            System.arraycopy(data, offset, this.complexData, 0, this.complexData.length);
        }
        return this.complexData.length;
    }

    public int serializeSimplePart(byte[] data, int pos) {
        LittleEndian.putShort(data, pos, this.getId());
        int recordSize = this.complexData.length;
        if (!this.sizeIncludesHeaderSize) {
            recordSize -= 6;
        }
        LittleEndian.putInt(data, pos + 2, recordSize);
        return 6;
    }

    public static int getActualSizeOfElements(short sizeOfElements) {
        if (sizeOfElements < 0) {
            return (short)(-sizeOfElements >> 2);
        }
        return sizeOfElements;
    }
}

