/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.TermSpans;

public class BoostingTermQuery
extends SpanTermQuery {
    public BoostingTermQuery(Term term) {
        super(term);
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new BoostingTermWeight(this, searcher);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BoostingTermQuery)) {
            return false;
        }
        BoostingTermQuery other = (BoostingTermQuery)o;
        return this.getBoost() == other.getBoost() && this.term.equals(other.term);
    }

    protected class BoostingTermWeight
    extends SpanWeight
    implements Weight {
        public BoostingTermWeight(BoostingTermQuery query, Searcher searcher) throws IOException {
            super(query, searcher);
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new BoostingSpanScorer((TermSpans)this.query.getSpans(reader), this, this.similarity, reader.norms(this.query.getField()));
        }

        protected class BoostingSpanScorer
        extends SpanScorer {
            byte[] payload;
            private TermPositions positions;
            protected float payloadScore;
            private int payloadsSeen;

            public BoostingSpanScorer(TermSpans spans, Weight weight, Similarity similarity, byte[] norms) throws IOException {
                super(spans, weight, similarity, norms);
                this.payload = new byte[256];
                this.positions = spans.getPositions();
            }

            protected boolean setFreqCurrentDoc() throws IOException {
                if (!this.more) {
                    return false;
                }
                this.doc = this.spans.doc();
                this.freq = 0.0f;
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
                Similarity similarity1 = this.getSimilarity();
                while (this.more && this.doc == this.spans.doc()) {
                    int matchLength = this.spans.end() - this.spans.start();
                    this.freq += similarity1.sloppyFreq(matchLength);
                    this.processPayload(similarity1);
                    this.more = this.spans.next();
                }
                return this.more || this.freq != 0.0f;
            }

            protected void processPayload(Similarity similarity) throws IOException {
                if (this.positions.isPayloadAvailable()) {
                    this.payload = this.positions.getPayload(this.payload, 0);
                    this.payloadScore += similarity.scorePayload(BoostingTermQuery.this.term.field(), this.payload, 0, this.positions.getPayloadLength());
                    ++this.payloadsSeen;
                }
            }

            public float score() throws IOException {
                return super.score() * (this.payloadsSeen > 0 ? this.payloadScore / (float)this.payloadsSeen : 1.0f);
            }

            public Explanation explain(int doc) throws IOException {
                ComplexExplanation result = new ComplexExplanation();
                Explanation nonPayloadExpl = super.explain(doc);
                result.addDetail(nonPayloadExpl);
                Explanation payloadBoost = new Explanation();
                result.addDetail(payloadBoost);
                float avgPayloadScore = this.payloadsSeen > 0 ? this.payloadScore / (float)this.payloadsSeen : 1.0f;
                payloadBoost.setValue(avgPayloadScore);
                payloadBoost.setDescription("scorePayload(...)");
                result.setValue(nonPayloadExpl.getValue() * avgPayloadScore);
                result.setDescription("btq, product of:");
                result.setMatch(nonPayloadExpl.getValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE);
                return result;
            }
        }
    }
}

