/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PngTextExtractor
extends AbstractTextExtractor {
    private static byte[] pngHeader = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static byte[] mngHeader = new byte[]{-119, 77, 78, 71, 13, 10, 26, 10};
    private static byte[] iendChunk = new byte[]{73, 69, 78, 68};
    private static byte[] tEXtChunk = new byte[]{116, 69, 88, 116};
    private static String separator = System.getProperty("line.separator");
    private static final Logger logger = LoggerFactory.getLogger(PngTextExtractor.class);

    public PngTextExtractor() {
        super(new String[]{"image/png", "image/apng", "image/mng"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            CharArrayWriter writer = new CharArrayWriter();
            byte[] header = new byte[8];
            stream.read(header);
            if (!Arrays.equals(pngHeader, header) && !Arrays.equals(mngHeader, header)) {
                StringReader stringReader = new StringReader("");
                return stringReader;
            }
            byte[] length = new byte[4];
            byte[] chunkType = new byte[4];
            stream.read(length);
            stream.read(chunkType);
            String sep = "";
            while (!Arrays.equals(chunkType, iendChunk)) {
                if (Arrays.equals(chunkType, tEXtChunk)) {
                    byte[] txtBytes = new byte[this.calcLen(length)];
                    stream.read(txtBytes);
                    int nullPos = this.findOffset(txtBytes, (byte)0);
                    String key = new String(txtBytes, 0, nullPos, "ISO-8859-1");
                    String value = new String(txtBytes, nullPos + 1, txtBytes.length - (nullPos + 1), "ISO-8859-1");
                    writer.write(key);
                    writer.write(": ");
                    writer.write(value);
                    writer.write(sep);
                    sep = separator;
                } else {
                    stream.skip(this.calcLen(length));
                }
                stream.skip(4L);
                stream.read(length);
                stream.read(chunkType);
            }
            CharArrayReader charArrayReader = new CharArrayReader(writer.toCharArray());
            return charArrayReader;
        }
        catch (IOException e) {
            logger.warn("Failed to extract png text content", e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }

    private int calcLen(byte[] length) {
        int len = 0xFF & length[0];
        len <<= 8;
        len |= 0xFF & length[1];
        len <<= 8;
        len |= 0xFF & length[2];
        len <<= 8;
        return len |= 0xFF & length[3];
    }

    int findOffset(byte[] data, byte val) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != val) continue;
            return i;
        }
        return -1;
    }
}

