/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestNetscapeDraftHeaderParser {
    @Test
    public void testNetscapeCookieParsing() throws Exception {
        NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
        String s = "name  = value; test; test1 =  stuff,with,commas   ; test2 =  \"stuff, stuff\"; test3=\"stuff";
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        HeaderElement he = parser.parseHeader(buffer, cursor);
        Assert.assertEquals((Object)"name", (Object)he.getName());
        Assert.assertEquals((Object)"value", (Object)he.getValue());
        NameValuePair[] params = he.getParameters();
        Assert.assertEquals((Object)"test", (Object)params[0].getName());
        Assert.assertEquals(null, (Object)params[0].getValue());
        Assert.assertEquals((Object)"test1", (Object)params[1].getName());
        Assert.assertEquals((Object)"stuff,with,commas", (Object)params[1].getValue());
        Assert.assertEquals((Object)"test2", (Object)params[2].getName());
        Assert.assertEquals((Object)"\"stuff, stuff\"", (Object)params[2].getValue());
        Assert.assertEquals((Object)"test3", (Object)params[3].getName());
        Assert.assertEquals((Object)"\"stuff", (Object)params[3].getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "  ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        he = parser.parseHeader(buffer, cursor);
        Assert.assertEquals((Object)"", (Object)he.getName());
        Assert.assertEquals(null, (Object)he.getValue());
    }
}

