/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.impl.client.integration.IntegrationTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.localserver.RequestBasicAuth;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClientReauthentication
extends IntegrationTestBase {
    @Before
    public void setUp() throws Exception {
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer("LocalTestServer/1.1")).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).add((HttpRequestInterceptor)new RequestBasicAuth()).add((HttpResponseInterceptor)new ResponseBasicUnauthorized()).build();
        this.localServer = new LocalTestServer(httpproc, null);
        this.startServer();
    }

    @Test
    public void testBasicAuthenticationSuccess() throws Exception {
        this.localServer.register("*", new AuthHandler());
        BasicSchemeFactory myBasicAuthSchemeFactory = new BasicSchemeFactory(){

            public AuthScheme create(HttpContext context) {
                return new BasicScheme(){

                    public String getSchemeName() {
                        return "MyBasic";
                    }
                };
            }
        };
        TargetAuthenticationStrategy myAuthStrategy = new TargetAuthenticationStrategy(){

            protected boolean isCachable(AuthScheme authScheme) {
                return "MyBasic".equalsIgnoreCase(authScheme.getSchemeName());
            }
        };
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        RequestConfig config = RequestConfig.custom().setTargetPreferredAuthSchemes(Arrays.asList("MyBasic")).build();
        Registry authSchemeRegistry = RegistryBuilder.create().register("MyBasic", (Object)myBasicAuthSchemeFactory).build();
        this.httpclient = HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setTargetAuthenticationStrategy((AuthenticationStrategy)myAuthStrategy).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpClientContext context = HttpClientContext.create();
        for (int i = 0; i < 10; ++i) {
            HttpGet httpget = new HttpGet("/");
            httpget.setConfig(config);
            CloseableHttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
            HttpEntity entity = response.getEntity();
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertNotNull((Object)entity);
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    static class TestCredentialsProvider
    implements CredentialsProvider {
        private final Credentials creds;
        private AuthScope authscope;

        TestCredentialsProvider(Credentials creds) {
            this.creds = creds;
        }

        public void clear() {
        }

        public Credentials getCredentials(AuthScope authscope) {
            this.authscope = authscope;
            return this.creds;
        }

        public void setCredentials(AuthScope authscope, Credentials credentials) {
        }

        public AuthScope getAuthScope() {
            return this.authscope;
        }
    }

    static class AuthHandler
    implements HttpRequestHandler {
        private final AtomicLong count = new AtomicLong(0L);

        AuthHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String creds = (String)context.getAttribute("creds");
            if (creds == null || !creds.equals("test:test")) {
                response.setStatusCode(401);
            } else if (this.count.incrementAndGet() % 4L == 0L) {
                response.setStatusCode(401);
            } else {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("success", Consts.ASCII);
                response.setEntity((HttpEntity)entity);
            }
        }
    }

    public class ResponseBasicUnauthorized
    implements HttpResponseInterceptor {
        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (response.getStatusLine().getStatusCode() == 401) {
                response.addHeader("WWW-Authenticate", "MyBasic realm=\"test realm\"");
            }
        }
    }
}

