/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.UUID;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ZKClusterId {
    private ZooKeeperWatcher watcher;
    private Abortable abortable;
    private String id;

    public ZKClusterId(ZooKeeperWatcher watcher, Abortable abortable) {
        this.watcher = watcher;
        this.abortable = abortable;
    }

    public boolean hasId() {
        return this.getId() != null;
    }

    public String getId() {
        try {
            if (this.id == null) {
                this.id = ZKClusterId.readClusterIdZNode(this.watcher);
            }
        }
        catch (KeeperException ke) {
            this.abortable.abort("Unexpected exception from ZooKeeper reading cluster ID", ke);
        }
        return this.id;
    }

    public static String readClusterIdZNode(ZooKeeperWatcher watcher) throws KeeperException {
        if (ZKUtil.checkExists(watcher, watcher.clusterIdZNode) != -1) {
            byte[] data;
            try {
                data = ZKUtil.getData(watcher, watcher.clusterIdZNode);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            if (data != null) {
                try {
                    return ClusterId.parseFrom(data).toString();
                }
                catch (DeserializationException e) {
                    throw ZKUtil.convert(e);
                }
            }
        }
        return null;
    }

    public static void setClusterId(ZooKeeperWatcher watcher, ClusterId id) throws KeeperException {
        ZKUtil.createSetData(watcher, watcher.clusterIdZNode, id.toByteArray());
    }

    public static UUID getUUIDForCluster(ZooKeeperWatcher zkw) throws KeeperException {
        String uuid = ZKClusterId.readClusterIdZNode(zkw);
        return uuid == null ? null : UUID.fromString(uuid);
    }
}

