/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;

@InterfaceAudience.Private
public class ScannerCallable
extends RegionServerCallable<Result[]> {
    public static final String LOG_SCANNER_LATENCY_CUTOFF = "hbase.client.log.scanner.latency.cutoff";
    public static final String LOG_SCANNER_ACTIVITY = "hbase.client.log.scanner.activity";
    public static final Log LOG = LogFactory.getLog(ScannerCallable.class);
    protected long scannerId = -1L;
    protected boolean instantiated = false;
    protected boolean closed = false;
    protected boolean renew = false;
    private Scan scan;
    private int caching = 1;
    protected final ClusterConnection cConnection;
    protected ScanMetrics scanMetrics;
    private boolean logScannerActivity = false;
    private int logCutOffLatency = 1000;
    private static String myAddress;
    protected final int id;
    protected boolean serverHasMoreResultsContext;
    protected boolean serverHasMoreResults;
    protected boolean heartbeatMessage = false;
    protected boolean isRegionServerRemote = true;
    private long nextCallSeq = 0L;
    protected RpcControllerFactory controllerFactory;
    protected PayloadCarryingRpcController controller;

    public ScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory rpcControllerFactory) {
        this(connection, tableName, scan, scanMetrics, rpcControllerFactory, 0);
    }

    public ScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory rpcControllerFactory, int id) {
        super(connection, tableName, scan.getStartRow());
        this.id = id;
        this.cConnection = connection;
        this.scan = scan;
        this.scanMetrics = scanMetrics;
        Configuration conf = connection.getConfiguration();
        this.logScannerActivity = conf.getBoolean(LOG_SCANNER_ACTIVITY, false);
        this.logCutOffLatency = conf.getInt(LOG_SCANNER_LATENCY_CUTOFF, 1000);
        this.controllerFactory = rpcControllerFactory;
    }

    PayloadCarryingRpcController getController() {
        return this.controller;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        RegionLocations rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(!reload, this.id, this.getConnection(), this.getTableName(), this.getRow());
        HRegionLocation hRegionLocation = this.location = this.id < rl.size() ? rl.getRegionLocation(this.id) : null;
        if (this.location == null || this.location.getServerName() == null) {
            throw new HBaseIOException("There is no location for replica id #" + this.id);
        }
        ServerName dest = this.location.getServerName();
        this.setStub(super.getConnection().getClient(dest));
        if (!this.instantiated || reload) {
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload && this.scanMetrics != null) {
            this.scanMetrics.countOfRPCRetries.incrementAndGet();
            if (this.isRegionServerRemote) {
                this.scanMetrics.countOfRemoteRPCRetries.incrementAndGet();
            }
        }
    }

    protected void checkIfRegionServerIsRemote() {
        this.isRegionServerRemote = !this.getLocation().getHostname().equalsIgnoreCase(myAddress);
    }

    @Override
    public Result[] call(int callTimeout) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (this.controller == null) {
            this.controller = this.controllerFactory.newController();
            this.controller.setPriority(this.getTableName());
            this.controller.setCallTimeout(callTimeout);
        }
        if (this.closed) {
            if (this.scannerId != -1L) {
                this.close();
            }
        } else if (this.scannerId == -1L) {
            this.scannerId = this.openScanner();
        } else {
            Result[] rrs = null;
            ClientProtos.ScanRequest request = null;
            this.setHeartbeatMessage(false);
            try {
                this.incRPCcallsMetrics();
                request = RequestConverter.buildScanRequest(this.scannerId, this.caching, false, this.nextCallSeq, this.scanMetrics != null, this.renew);
                ClientProtos.ScanResponse response = null;
                try {
                    long now;
                    response = this.getStub().scan(this.controller, request);
                    ++this.nextCallSeq;
                    long timestamp = System.currentTimeMillis();
                    this.setHeartbeatMessage(response.hasHeartbeatMessage() && response.getHeartbeatMessage());
                    CellScanner cellScanner = this.controller.cellScanner();
                    rrs = ResponseConverter.getResults(cellScanner, response);
                    if (this.logScannerActivity && (now = System.currentTimeMillis()) - timestamp > (long)this.logCutOffLatency) {
                        int rows = rrs == null ? 0 : rrs.length;
                        LOG.info((Object)("Took " + (now - timestamp) + "ms to fetch " + rows + " rows from scanner=" + this.scannerId));
                    }
                    this.updateServerSideMetrics(response);
                    if (response.hasMoreResults() && !response.getMoreResults()) {
                        this.scannerId = -1L;
                        this.closed = true;
                        return null;
                    }
                    if (response.hasMoreResultsInRegion()) {
                        this.setHasMoreResultsContext(true);
                        this.setServerHasMoreResults(response.getMoreResultsInRegion());
                    } else {
                        this.setHasMoreResultsContext(false);
                    }
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
                this.updateResultsMetrics(rrs);
            }
            catch (IOException e) {
                if (this.logScannerActivity) {
                    LOG.info((Object)("Got exception making request " + TextFormat.shortDebugString(request) + " to " + this.getLocation()), (Throwable)e);
                }
                IOException ioe = e;
                if (e instanceof RemoteException) {
                    ioe = RemoteExceptionHandler.decodeRemoteException((RemoteException)e);
                }
                if (this.logScannerActivity) {
                    if (ioe instanceof UnknownScannerException) {
                        try {
                            HRegionLocation location = this.getConnection().relocateRegion(this.getTableName(), this.scan.getStartRow());
                            LOG.info((Object)("Scanner=" + this.scannerId + " expired, current region location is " + location.toString()));
                        }
                        catch (Throwable t) {
                            LOG.info((Object)"Failed to relocate region", t);
                        }
                    } else if (ioe instanceof ScannerResetException) {
                        LOG.info((Object)("Scanner=" + this.scannerId + " has received an exception, and the server " + "asked us to reset the scanner state."), (Throwable)ioe);
                    }
                }
                if (ioe instanceof NotServingRegionException) {
                    if (this.scanMetrics != null) {
                        this.scanMetrics.countOfNSRE.incrementAndGet();
                    }
                    throw new DoNotRetryIOException("Resetting the scanner -- see exception cause", ioe);
                }
                if (ioe instanceof RegionServerStoppedException) {
                    throw new DoNotRetryIOException("Resetting the scanner -- see exception cause", ioe);
                }
                throw ioe;
            }
            return rrs;
        }
        return null;
    }

    protected boolean isHeartbeatMessage() {
        return this.heartbeatMessage;
    }

    protected void setHeartbeatMessage(boolean heartbeatMessage) {
        this.heartbeatMessage = heartbeatMessage;
    }

    private void incRPCcallsMetrics() {
        if (this.scanMetrics == null) {
            return;
        }
        this.scanMetrics.countOfRPCcalls.incrementAndGet();
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfRemoteRPCcalls.incrementAndGet();
        }
    }

    protected void updateResultsMetrics(Result[] rrs) {
        if (this.scanMetrics == null || rrs == null || rrs.length == 0) {
            return;
        }
        long resultSize = 0L;
        for (Result rr : rrs) {
            for (Cell cell : rr.rawCells()) {
                resultSize += (long)CellUtil.estimatedSerializedSizeOf(cell);
            }
        }
        this.scanMetrics.countOfBytesInResults.addAndGet(resultSize);
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfBytesInRemoteResults.addAndGet(resultSize);
        }
    }

    private void updateServerSideMetrics(ClientProtos.ScanResponse response) {
        if (this.scanMetrics == null || response == null || !response.hasScanMetrics()) {
            return;
        }
        Map<String, Long> serverMetrics = ResponseConverter.getScanMetrics(response);
        for (Map.Entry<String, Long> entry : serverMetrics.entrySet()) {
            this.scanMetrics.addToCounter(entry.getKey(), entry.getValue());
        }
    }

    private void close() {
        if (this.scannerId == -1L) {
            return;
        }
        try {
            this.incRPCcallsMetrics();
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.scannerId, 0, true, this.scanMetrics != null);
            try {
                this.getStub().scan(this.controller, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Ignore, probably already closed", (Throwable)e);
        }
        this.scannerId = -1L;
    }

    protected long openScanner() throws IOException {
        this.incRPCcallsMetrics();
        ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.getLocation().getRegionInfo().getRegionName(), this.scan, 0, false);
        try {
            ClientProtos.ScanResponse response = this.getStub().scan(this.controller, request);
            long id = response.getScannerId();
            if (this.logScannerActivity) {
                LOG.info((Object)("Open scanner=" + id + " for scan=" + this.scan.toString() + " on region " + this.getLocation().toString()));
            }
            return id;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    protected Scan getScan() {
        return this.scan;
    }

    public void setClose() {
        this.closed = true;
    }

    public void setRenew(boolean val) {
        this.renew = val;
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        if (!this.instantiated) {
            return null;
        }
        return this.getLocation().getRegionInfo();
    }

    public int getCaching() {
        return this.caching;
    }

    @Override
    public ClusterConnection getConnection() {
        return this.cConnection;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    public ScannerCallable getScannerCallableForReplica(int id) {
        ScannerCallable s = new ScannerCallable(this.getConnection(), this.tableName, this.getScan(), this.scanMetrics, this.controllerFactory, id);
        s.setCaching(this.caching);
        return s;
    }

    protected boolean getServerHasMoreResults() {
        assert (this.serverHasMoreResultsContext);
        return this.serverHasMoreResults;
    }

    protected void setServerHasMoreResults(boolean serverHasMoreResults) {
        this.serverHasMoreResults = serverHasMoreResults;
    }

    protected boolean hasMoreResultsContext() {
        return this.serverHasMoreResultsContext;
    }

    protected void setHasMoreResultsContext(boolean serverHasMoreResultsContext) {
        this.serverHasMoreResultsContext = serverHasMoreResultsContext;
    }

    static {
        try {
            myAddress = DNS.getDefaultHost("default", "default");
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"cannot determine my address", (Throwable)uhe);
        }
    }
}

