/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public abstract class RegionServerCallable<T>
implements RetryingCallable<T> {
    private static final Log LOG = LogFactory.getLog(RegionServerCallable.class);
    protected final Connection connection;
    protected final TableName tableName;
    protected final byte[] row;
    protected HRegionLocation location;
    private ClientProtos.ClientService.BlockingInterface stub;
    protected static final int MIN_WAIT_DEAD_SERVER = 10000;

    public RegionServerCallable(Connection connection, TableName tableName, byte[] row) {
        this.connection = connection;
        this.tableName = tableName;
        this.row = row;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (reload && !this.tableName.equals(TableName.META_TABLE_NAME) && this.getConnection().isTableDisabled(this.tableName)) {
            throw new TableNotEnabledException(this.tableName.getNameAsString() + " is disabled.");
        }
        try (RegionLocator regionLocator = this.connection.getRegionLocator(this.tableName);){
            this.location = regionLocator.getRegionLocation(this.row);
        }
        if (this.location == null) {
            throw new IOException("Failed to find location, tableName=" + this.tableName + ", row=" + Bytes.toString(this.row) + ", reload=" + reload);
        }
        this.setStub(this.getConnection().getClient(this.location.getServerName()));
    }

    HConnection getConnection() {
        return (HConnection)this.connection;
    }

    protected ClientProtos.ClientService.BlockingInterface getStub() {
        return this.stub;
    }

    void setStub(ClientProtos.ClientService.BlockingInterface stub) {
        this.stub = stub;
    }

    protected HRegionLocation getLocation() {
        return this.location;
    }

    protected void setLocation(HRegionLocation location) {
        this.location = location;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public byte[] getRow() {
        return this.row;
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
        if (this.location != null) {
            this.getConnection().updateCachedLocations(this.tableName, this.location.getRegionInfo().getRegionName(), this.row, t, this.location.getServerName());
        }
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return "row '" + Bytes.toString(this.row) + "' on table '" + this.tableName + "' at " + this.location;
    }

    @Override
    public long sleep(long pause, int tries) {
        long sleep = ConnectionUtils.getPauseTime(pause, tries);
        if (sleep < 10000L && (this.location == null || this.getConnection().isDeadServer(this.location.getServerName()))) {
            sleep = ConnectionUtils.addJitter(10000L, 0.1f);
        }
        return sleep;
    }

    public HRegionInfo getHRegionInfo() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo();
    }
}

