/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.zookeeper.KeeperException;
import org.cloudera.htrace.Trace;

@InterfaceAudience.Private
public class DisableTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(DisableTableHandler.class);
    private final TableName tableName;
    private final AssignmentManager assignmentManager;
    private final TableLockManager tableLockManager;
    private final CatalogTracker catalogTracker;
    private final boolean skipTableStateCheck;
    private TableLockManager.TableLock tableLock;

    public DisableTableHandler(Server server, TableName tableName, CatalogTracker catalogTracker, AssignmentManager assignmentManager, TableLockManager tableLockManager, boolean skipTableStateCheck) {
        super(server, EventType.C_M_DISABLE_TABLE);
        this.tableName = tableName;
        this.assignmentManager = assignmentManager;
        this.catalogTracker = catalogTracker;
        this.tableLockManager = tableLockManager;
        this.skipTableStateCheck = skipTableStateCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableTableHandler prepare() throws TableNotFoundException, TableNotEnabledException, IOException {
        if (this.tableName.equals((Object)TableName.META_TABLE_NAME)) {
            throw new ConstraintException("Cannot disable catalog table");
        }
        this.tableLock = this.tableLockManager.writeLock(this.tableName, EventType.C_M_DISABLE_TABLE.toString());
        this.tableLock.acquire();
        boolean success = false;
        try {
            if (!MetaReader.tableExists((CatalogTracker)this.catalogTracker, (TableName)this.tableName)) {
                throw new TableNotFoundException(this.tableName);
            }
            if (!this.skipTableStateCheck) {
                try {
                    if (!this.assignmentManager.getZKTable().checkEnabledAndSetDisablingTable(this.tableName)) {
                        LOG.info((Object)("Table " + this.tableName + " isn't enabled; skipping disable"));
                        throw new TableNotEnabledException(this.tableName);
                    }
                }
                catch (KeeperException e) {
                    throw new IOException("Unable to ensure that the table will be disabling because of a ZooKeeper issue", e);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.releaseTableLock();
            }
        }
        return this;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            LOG.info((Object)("Attempting to disable table " + this.tableName));
            MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
            if (cpHost != null) {
                cpHost.preDisableTableHandler(this.tableName);
            }
            this.handleDisableTable();
            if (cpHost != null) {
                cpHost.postDisableTableHandler(this.tableName);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to disable table " + this.tableName), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error trying to disable table " + this.tableName), (Throwable)e);
        }
        finally {
            this.releaseTableLock();
        }
    }

    private void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Could not release the table lock", (Throwable)ex);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void handleDisableTable() throws IOException, KeeperException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class BulkDisabler
    extends BulkAssigner {
        private final List<HRegionInfo> regions;

        BulkDisabler(Server server, List<HRegionInfo> regions) {
            super(server);
            this.regions = regions;
        }

        @Override
        protected void populatePool(ExecutorService pool) {
            RegionStates regionStates = DisableTableHandler.this.assignmentManager.getRegionStates();
            for (HRegionInfo region : this.regions) {
                if (regionStates.isRegionInTransition(region) && !regionStates.isRegionInState(region, RegionState.State.FAILED_CLOSE)) continue;
                final HRegionInfo hri = region;
                pool.execute(Trace.wrap((String)"DisableTableHandler.BulkDisabler", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DisableTableHandler.this.assignmentManager.unassign(hri, true);
                    }
                }));
            }
        }

        @Override
        protected boolean waitUntilDone(long timeout) throws InterruptedException {
            long startTime = System.currentTimeMillis();
            long remaining = timeout;
            List<HRegionInfo> regions = null;
            while (!this.server.isStopped() && remaining > 0L) {
                Thread.sleep(DisableTableHandler.this.waitingTimeForEvents);
                regions = DisableTableHandler.this.assignmentManager.getRegionStates().getRegionsOfTable(DisableTableHandler.this.tableName);
                LOG.debug((Object)("Disable waiting until done; " + remaining + " ms remaining; " + regions));
                if (regions.isEmpty()) break;
                remaining = timeout - (System.currentTimeMillis() - startTime);
            }
            return regions != null && regions.isEmpty();
        }
    }
}

