/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourcePBImpl
extends Resource {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePBImpl.class);
    YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.getDefaultInstance();
    YarnProtos.ResourceProto.Builder builder = null;
    boolean viaProto = false;

    static YarnProtos.ResourceProto getProto(Resource r) {
        ResourcePBImpl pb;
        if (r instanceof ResourcePBImpl) {
            pb = (ResourcePBImpl)r;
        } else {
            pb = new ResourcePBImpl();
            pb.setMemorySize(r.getMemorySize());
            pb.setVirtualCores(r.getVirtualCores());
            for (ResourceInformation res : r.getResources()) {
                pb.setResourceInformation(res.getName(), res);
            }
        }
        return pb.getProto();
    }

    public ResourcePBImpl() {
        this.builder = YarnProtos.ResourceProto.newBuilder();
        this.initResources();
    }

    public ResourcePBImpl(YarnProtos.ResourceProto proto) {
        this.proto = proto;
        this.viaProto = true;
        this.initResources();
    }

    public synchronized YarnProtos.ResourceProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceProto.newBuilder((YarnProtos.ResourceProto)this.proto);
        }
        this.viaProto = false;
    }

    public int getMemory() {
        return ResourcePBImpl.castToIntSafely((long)this.getMemorySize());
    }

    public long getMemorySize() {
        ResourceInformation ri = this.resources[0];
        if (ri.getUnits().isEmpty()) {
            return ri.getValue();
        }
        return UnitsConversionUtil.convert((String)ri.getUnits(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)ri.getValue());
    }

    public void setMemory(int memory) {
        this.setMemorySize(memory);
    }

    public void setMemorySize(long memory) {
        this.maybeInitBuilder();
        this.resources[0].setValue(memory);
    }

    public int getVirtualCores() {
        return ResourcePBImpl.castToIntSafely((long)this.resources[1].getValue());
    }

    public void setVirtualCores(int vCores) {
        this.maybeInitBuilder();
        this.resources[1].setValue((long)vCores);
    }

    private synchronized void initResources() {
        if (this.resources != null) {
            return;
        }
        YarnProtos.ResourceProto p = this.viaProto ? this.proto : this.builder;
        ResourceInformation[] types = ResourceUtils.getResourceTypesArray();
        Map indexMap = ResourceUtils.getResourceTypeIndex();
        this.resources = new ResourceInformation[types.length];
        for (YarnProtos.ResourceInformationProto entry : p.getResourceValueMapList()) {
            Integer index = (Integer)indexMap.get(entry.getKey());
            if (index == null) {
                LOG.warn("Got unknown resource type: " + entry.getKey() + "; skipping");
                continue;
            }
            this.resources[index.intValue()] = ResourcePBImpl.newDefaultInformation(types[index], entry);
        }
        this.resources[0] = ResourceInformation.newInstance((ResourceInformation)ResourceInformation.MEMORY_MB);
        this.resources[1] = ResourceInformation.newInstance((ResourceInformation)ResourceInformation.VCORES);
        this.setMemorySize(p.getMemory());
        this.setVirtualCores(p.getVirtualCores());
        this.updateResourceInformationMap(types);
    }

    private void updateResourceInformationMap(ResourceInformation[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (this.resources[i] != null) continue;
            this.resources[i] = ResourceInformation.newInstance((ResourceInformation)types[i]);
        }
    }

    private static ResourceInformation newDefaultInformation(ResourceInformation resourceInformation, YarnProtos.ResourceInformationProto entry) {
        ResourceInformation ri = new ResourceInformation();
        ri.setName(resourceInformation.getName());
        ri.setMinimumAllocation(resourceInformation.getMinimumAllocation());
        ri.setMaximumAllocation(resourceInformation.getMaximumAllocation());
        ri.setResourceType(entry.hasType() ? ProtoUtils.convertFromProtoFormat(entry.getType()) : ResourceTypes.COUNTABLE);
        String units = entry.hasUnits() ? entry.getUnits() : ResourceUtils.getDefaultUnit((String)entry.getKey());
        long value = entry.hasValue() ? entry.getValue() : 0L;
        String destUnit = ResourceUtils.getDefaultUnit((String)entry.getKey());
        if (!units.equals(destUnit)) {
            ri.setValue(UnitsConversionUtil.convert((String)units, (String)destUnit, (long)value));
            ri.setUnits(destUnit);
        } else {
            ri.setUnits(units);
            ri.setValue(value);
        }
        if (entry.getTagsCount() > 0) {
            ri.setTags(new HashSet(entry.getTagsList()));
        } else {
            ri.setTags((Set)ImmutableSet.of());
        }
        if (entry.getAttributesCount() > 0) {
            ri.setAttributes(ProtoUtils.convertStringStringMapProtoListToMap(entry.getAttributesList()));
        } else {
            ri.setAttributes((Map)ImmutableMap.of());
        }
        return ri;
    }

    public void setResourceInformation(String resource, ResourceInformation resourceInformation) {
        this.maybeInitBuilder();
        if (resource == null || resourceInformation == null) {
            throw new IllegalArgumentException("resource and/or resourceInformation cannot be null");
        }
        ResourceInformation storedResourceInfo = super.getResourceInformation(resource);
        ResourceInformation.copy((ResourceInformation)resourceInformation, (ResourceInformation)storedResourceInfo);
    }

    public void setResourceValue(String resource, long value) {
        this.maybeInitBuilder();
        if (resource == null) {
            throw new IllegalArgumentException("resource type object cannot be null");
        }
        this.getResourceInformation(resource).setValue(value);
    }

    public ResourceInformation getResourceInformation(String resource) {
        this.initResources();
        return super.getResourceInformation(resource);
    }

    public long getResourceValue(String resource) {
        return super.getResourceValue(resource);
    }

    private synchronized void mergeLocalToBuilder() {
        this.builder.clearResourceValueMap();
        if (this.resources != null && this.resources.length != 0) {
            for (ResourceInformation resInfo : this.resources) {
                YarnProtos.ResourceInformationProto.Builder e = YarnProtos.ResourceInformationProto.newBuilder();
                e.setKey(resInfo.getName());
                e.setUnits(resInfo.getUnits());
                e.setType(ProtoUtils.converToProtoFormat(resInfo.getResourceType()));
                e.setValue(resInfo.getValue());
                if (resInfo.getAttributes() != null && !resInfo.getAttributes().isEmpty()) {
                    e.addAllAttributes(ProtoUtils.convertToProtoFormat(resInfo.getAttributes()));
                }
                if (resInfo.getTags() != null && !resInfo.getTags().isEmpty()) {
                    e.addAllTags((Iterable)resInfo.getTags());
                }
                this.builder.addResourceValueMap(e);
            }
        }
        this.builder.setMemory(this.getMemorySize());
        this.builder.setVirtualCores(this.getVirtualCores());
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }
}

