/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.hamlet;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class HamletImpl
extends HamletSpec {
    private static final String INDENT_CHARS = "  ";
    private static final Splitter SS = Splitter.on((char)'.').omitEmptyStrings().trimResults();
    private static final Joiner SJ = Joiner.on((char)' ');
    private static final Joiner CJ = Joiner.on((String)", ");
    static final int S_ID = 0;
    static final int S_CLASS = 1;
    int nestLevel;
    int indents;
    private final PrintWriter out;
    private final StringBuilder sb = new StringBuilder();
    private boolean wasInline = false;

    public HamletImpl(PrintWriter out, int nestLevel, boolean wasInline) {
        this.out = out;
        this.nestLevel = nestLevel;
        this.wasInline = wasInline;
    }

    public int nestLevel() {
        return this.nestLevel;
    }

    public boolean wasInline() {
        return this.wasInline;
    }

    public void setWasInline(boolean state) {
        this.wasInline = state;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public <T extends HamletSpec._> Generic<T> root(String name, EnumSet<EOpt> opts) {
        return new Generic(this, name, null, opts);
    }

    public <T extends HamletSpec._> Generic<T> root(String name) {
        return this.root(name, EnumSet.of(EOpt.ENDTAG));
    }

    protected void printStartTag(String name, EnumSet<EOpt> opts) {
        this.indent(opts);
        this.sb.setLength(0);
        this.out.print(this.sb.append('<').append(name).toString());
    }

    protected void indent(EnumSet<EOpt> opts) {
        if (opts.contains(EOpt.INLINE) && this.wasInline) {
            return;
        }
        if (this.wasInline) {
            this.out.println();
        }
        this.wasInline = opts.contains(EOpt.INLINE) || opts.contains(EOpt.PRE);
        for (int i = 0; i < this.nestLevel; ++i) {
            this.out.print("  ");
        }
        ++this.indents;
    }

    protected void printEndTag(String name, EnumSet<EOpt> opts) {
        if (!opts.contains(EOpt.ENDTAG)) {
            return;
        }
        if (!opts.contains(EOpt.PRE)) {
            this.indent(opts);
        } else {
            this.wasInline = opts.contains(EOpt.INLINE);
        }
        this.sb.setLength(0);
        this.out.print(this.sb.append("</").append(name).append('>').toString());
        if (!opts.contains(EOpt.INLINE)) {
            this.out.println();
        }
    }

    protected void printAttr(String name, String value) {
        this.sb.setLength(0);
        this.sb.append(' ').append(name);
        if (value != null) {
            this.sb.append("=\"").append(StringEscapeUtils.escapeHtml((String)value)).append("\"");
        }
        this.out.print(this.sb.toString());
    }

    protected void subView(Class<? extends SubView> cls) {
        this.indent(EnumSet.of(EOpt.ENDTAG));
        this.sb.setLength(0);
        this.out.print(this.sb.append('[').append(cls.getName()).append(']').toString());
        this.out.println();
    }

    public static String[] parseSelector(String selector) {
        String[] result = new String[]{null, null};
        Iterable rs = SS.split((CharSequence)selector);
        Iterator it = rs.iterator();
        if (it.hasNext()) {
            String maybeId = (String)it.next();
            if (maybeId.charAt(0) == '#') {
                result[0] = maybeId.substring(1);
                if (it.hasNext()) {
                    result[1] = SJ.join(Iterables.skip((Iterable)rs, (int)1));
                }
            } else {
                result[1] = SJ.join(rs);
            }
            return result;
        }
        throw new WebAppException("Error parsing selector: " + selector);
    }

    public static <E extends HamletSpec.CoreAttrs> E setSelector(E e, String selector) {
        String[] res = HamletImpl.parseSelector((String)selector);
        if (res[0] != null) {
            e.$id(res[0]);
        }
        if (res[1] != null) {
            e.$class(res[1]);
        }
        return e;
    }

    public static <E extends HamletSpec.LINK> E setLinkHref(E e, String href) {
        if (href.endsWith(".css")) {
            e.$rel("stylesheet");
        }
        e.$href(href);
        return e;
    }

    public static <E extends HamletSpec.SCRIPT> E setScriptSrc(E e, String src) {
        if (src.endsWith(".js")) {
            e.$type("text/javascript");
        }
        e.$src(src);
        return e;
    }

    static /* synthetic */ PrintWriter access$000(HamletImpl x0) {
        return x0.out;
    }

    static /* synthetic */ Joiner access$100() {
        return CJ;
    }

    static /* synthetic */ Joiner access$200() {
        return SJ;
    }
}

