/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.yarn.exceptions.YarnException;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class RPCUtil {
    public static YarnException getRemoteException(Throwable t) {
        return new YarnException(t);
    }

    public static YarnException getRemoteException(String message) {
        return new YarnException(message);
    }

    private static <T extends Throwable> T instantiateException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        try {
            Constructor<T> cn = cls.getConstructor(String.class);
            cn.setAccessible(true);
            Throwable ex = (Throwable)cn.newInstance(re.getMessage());
            ex.initCause((Throwable)re);
            return (T)ex;
        }
        catch (NoSuchMethodException e) {
            throw re;
        }
        catch (IllegalArgumentException e) {
            throw re;
        }
        catch (SecurityException e) {
            throw re;
        }
        catch (InstantiationException e) {
            throw re;
        }
        catch (IllegalAccessException e) {
            throw re;
        }
        catch (InvocationTargetException e) {
            throw re;
        }
    }

    public static Void unwrapAndThrowException(ServiceException se) throws IOException, YarnException {
        Throwable cause = se.getCause();
        if (cause == null) {
            throw new IOException(se);
        }
        if (cause instanceof RemoteException) {
            RemoteException re = (RemoteException)cause;
            Class<?> realClass = null;
            try {
                realClass = Class.forName(re.getClassName());
            }
            catch (ClassNotFoundException cnf) {
                throw (YarnException)RPCUtil.instantiateException(YarnException.class, (RemoteException)re);
            }
            if (YarnException.class.isAssignableFrom(realClass)) {
                throw (YarnException)RPCUtil.instantiateException(realClass.asSubclass(YarnException.class), (RemoteException)re);
            }
            if (IOException.class.isAssignableFrom(realClass)) {
                throw (IOException)RPCUtil.instantiateException(realClass.asSubclass(IOException.class), (RemoteException)re);
            }
            if (RuntimeException.class.isAssignableFrom(realClass)) {
                throw (RuntimeException)RPCUtil.instantiateException(realClass.asSubclass(RuntimeException.class), (RemoteException)re);
            }
            throw re;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new IOException(se);
    }
}

