/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.PreemptionContainer;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.PreemptionContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PreemptionContractPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PreemptionResourceRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PreemptionContractPBImpl
extends PreemptionContract {
    YarnProtos.PreemptionContractProto proto = YarnProtos.PreemptionContractProto.getDefaultInstance();
    YarnProtos.PreemptionContractProto.Builder builder = null;
    boolean viaProto = false;
    private Set<PreemptionContainer> containers;
    private List<PreemptionResourceRequest> resources;

    public PreemptionContractPBImpl() {
        this.builder = YarnProtos.PreemptionContractProto.newBuilder();
    }

    public PreemptionContractPBImpl(YarnProtos.PreemptionContractProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.PreemptionContractProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals((Object)((PreemptionContractPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.resources != null) {
            this.addResourcesToProto();
        }
        if (this.containers != null) {
            this.addContainersToProto();
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.PreemptionContractProto.newBuilder((YarnProtos.PreemptionContractProto)this.proto);
        }
        this.viaProto = false;
    }

    public synchronized Set<PreemptionContainer> getContainers() {
        this.initPreemptionContainers();
        return this.containers;
    }

    public synchronized void setContainers(Set<PreemptionContainer> containers) {
        if (null == containers) {
            this.builder.clearContainer();
        }
        this.containers = containers;
    }

    public synchronized List<PreemptionResourceRequest> getResourceRequest() {
        this.initPreemptionResourceRequests();
        return this.resources;
    }

    public synchronized void setResourceRequest(List<PreemptionResourceRequest> req) {
        if (null == this.resources) {
            this.builder.clearResource();
        }
        this.resources = req;
    }

    private void initPreemptionResourceRequests() {
        if (this.resources != null) {
            return;
        }
        YarnProtos.PreemptionContractProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getResourceList();
        this.resources = new ArrayList();
        for (YarnProtos.PreemptionResourceRequestProto rr : list) {
            this.resources.add(this.convertFromProtoFormat(rr));
        }
    }

    private void addResourcesToProto() {
        this.maybeInitBuilder();
        this.builder.clearResource();
        if (null == this.resources) {
            return;
        }
        1 iterable = new /* Unavailable Anonymous Inner Class!! */;
        this.builder.addAllResource((Iterable)iterable);
    }

    private void initPreemptionContainers() {
        if (this.containers != null) {
            return;
        }
        YarnProtos.PreemptionContractProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getContainerList();
        this.containers = new HashSet();
        for (YarnProtos.PreemptionContainerProto c : list) {
            this.containers.add(this.convertFromProtoFormat(c));
        }
    }

    private void addContainersToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainer();
        if (null == this.containers) {
            return;
        }
        2 iterable = new /* Unavailable Anonymous Inner Class!! */;
        this.builder.addAllContainer((Iterable)iterable);
    }

    private PreemptionContainerPBImpl convertFromProtoFormat(YarnProtos.PreemptionContainerProto p) {
        return new PreemptionContainerPBImpl(p);
    }

    private YarnProtos.PreemptionContainerProto convertToProtoFormat(PreemptionContainer t) {
        return ((PreemptionContainerPBImpl)t).getProto();
    }

    private PreemptionResourceRequestPBImpl convertFromProtoFormat(YarnProtos.PreemptionResourceRequestProto p) {
        return new PreemptionResourceRequestPBImpl(p);
    }

    private YarnProtos.PreemptionResourceRequestProto convertToProtoFormat(PreemptionResourceRequest t) {
        return ((PreemptionResourceRequestPBImpl)t).getProto();
    }

    static /* synthetic */ List access$000(PreemptionContractPBImpl x0) {
        return x0.resources;
    }

    static /* synthetic */ YarnProtos.PreemptionResourceRequestProto access$100(PreemptionContractPBImpl x0, PreemptionResourceRequest x1) {
        return x0.convertToProtoFormat(x1);
    }

    static /* synthetic */ Set access$200(PreemptionContractPBImpl x0) {
        return x0.containers;
    }

    static /* synthetic */ YarnProtos.PreemptionContainerProto access$300(PreemptionContractPBImpl x0, PreemptionContainer x1) {
        return x0.convertToProtoFormat(x1);
    }
}

