/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.nativeio.Errno;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestNativeIO {
    static final Log LOG = LogFactory.getLog(TestNativeIO.class);
    static final File TEST_DIR = new File(System.getProperty("test.build.data"), "testnativeio");

    @Before
    public void checkLoaded() {
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
    }

    @Before
    public void setupTestDir() {
        FileUtil.fullyDelete((File)TEST_DIR);
        TEST_DIR.mkdirs();
    }

    @Test(timeout=30000L)
    public void testFstat() throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(TEST_DIR, "testfstat"));
        NativeIO.POSIX.Stat stat = NativeIO.POSIX.getFstat((FileDescriptor)fos.getFD());
        fos.close();
        LOG.info((Object)("Stat: " + String.valueOf(stat)));
        String owner = stat.getOwner();
        String expectedOwner = System.getProperty("user.name");
        if (Path.WINDOWS) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)expectedOwner);
            String adminsGroupString = "Administrators";
            if (Arrays.asList(ugi.getGroupNames()).contains("Administrators")) {
                expectedOwner = "Administrators";
            }
        }
        Assert.assertEquals((Object)expectedOwner, (Object)owner);
        Assert.assertNotNull((Object)stat.getGroup());
        Assert.assertTrue((!stat.getGroup().isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Stat mode field should indicate a regular file", (long)32768L, (long)(stat.getMode() & 0xF000));
    }

    @Test(timeout=30000L)
    public void testMultiThreadedFstat() throws Exception {
        if (Path.WINDOWS) {
            return;
        }
        final FileOutputStream fos = new FileOutputStream(new File(TEST_DIR, "testfstat"));
        final AtomicReference thrown = new AtomicReference();
        ArrayList<1> statters = new ArrayList<1>();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    long et = Time.now() + 5000L;
                    while (Time.now() < et) {
                        try {
                            NativeIO.POSIX.Stat stat = NativeIO.POSIX.getFstat((FileDescriptor)fos.getFD());
                            Assert.assertEquals((Object)System.getProperty("user.name"), (Object)stat.getOwner());
                            Assert.assertNotNull((Object)stat.getGroup());
                            Assert.assertTrue((!stat.getGroup().isEmpty() ? 1 : 0) != 0);
                            Assert.assertEquals((String)"Stat mode field should indicate a regular file", (long)32768L, (long)(stat.getMode() & 0xF000));
                        }
                        catch (Throwable t) {
                            thrown.set(t);
                        }
                    }
                }
            };
            statters.add(thread);
            thread.start();
        }
        for (Thread thread : statters) {
            thread.join();
        }
        fos.close();
        if (thrown.get() != null) {
            throw new RuntimeException((Throwable)thrown.get());
        }
    }

    @Test(timeout=30000L)
    public void testFstatClosedFd() throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(TEST_DIR, "testfstat2"));
        fos.close();
        try {
            NativeIO.POSIX.Stat stat = NativeIO.POSIX.getFstat((FileDescriptor)fos.getFD());
        }
        catch (NativeIOException nioe) {
            LOG.info((Object)"Got expected exception", (Throwable)nioe);
            Assert.assertEquals((Object)Errno.EBADF, (Object)nioe.getErrno());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSetFilePointer() throws Exception {
        if (!Path.WINDOWS) {
            return;
        }
        LOG.info((Object)"Set a file pointer on Windows");
        try {
            File testfile = new File(TEST_DIR, "testSetFilePointer");
            Assert.assertTrue((String)"Create test subject", (testfile.exists() || testfile.createNewFile() ? 1 : 0) != 0);
            FileWriter writer = new FileWriter(testfile);
            try {
                for (int i = 0; i < 200; ++i) {
                    if (i < 100) {
                        writer.write(97);
                        continue;
                    }
                    writer.write(98);
                }
                writer.flush();
            }
            catch (Exception writerException) {
                Assert.fail((String)("Got unexpected exception: " + writerException.getMessage()));
            }
            finally {
                writer.close();
            }
            FileDescriptor fd = NativeIO.Windows.createFile((String)testfile.getCanonicalPath(), (long)0x80000000L, (long)7L, (long)3L);
            NativeIO.Windows.setFilePointer((FileDescriptor)fd, (long)120L, (long)0L);
            FileReader reader = new FileReader(fd);
            try {
                int c = reader.read();
                Assert.assertTrue((String)("Unexpected character: " + c), (c == 98 ? 1 : 0) != 0);
            }
            catch (Exception readerException) {
                Assert.fail((String)("Got unexpected exception: " + readerException.getMessage()));
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Got unexpected exception: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCreateFile() throws Exception {
        if (!Path.WINDOWS) {
            return;
        }
        LOG.info((Object)"Open a file on Windows with SHARE_DELETE shared mode");
        try {
            File testfile = new File(TEST_DIR, "testCreateFile");
            Assert.assertTrue((String)"Create test subject", (testfile.exists() || testfile.createNewFile() ? 1 : 0) != 0);
            FileDescriptor fd = NativeIO.Windows.createFile((String)testfile.getCanonicalPath(), (long)0x80000000L, (long)7L, (long)3L);
            FileInputStream fin = new FileInputStream(fd);
            try {
                fin.read();
                File newfile = new File(TEST_DIR, "testRenamedFile");
                boolean renamed = testfile.renameTo(newfile);
                Assert.assertTrue((String)"Rename failed.", (boolean)renamed);
                fin.read();
            }
            catch (Exception e) {
                Assert.fail((String)("Got unexpected exception: " + e.getMessage()));
            }
            finally {
                fin.close();
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Got unexpected exception: " + e.getMessage()));
        }
    }

    @Test(timeout=30000L)
    public void testAccess() throws Exception {
        if (!Path.WINDOWS) {
            return;
        }
        File testFile = new File(TEST_DIR, "testfileaccess");
        Assert.assertTrue((boolean)testFile.createNewFile());
        FileUtil.setReadable((File)testFile, (boolean)false);
        Assert.assertFalse((boolean)NativeIO.Windows.access((String)testFile.getAbsolutePath(), (NativeIO.Windows.AccessRight)NativeIO.Windows.AccessRight.ACCESS_READ));
        FileUtil.setReadable((File)testFile, (boolean)true);
        Assert.assertTrue((boolean)NativeIO.Windows.access((String)testFile.getAbsolutePath(), (NativeIO.Windows.AccessRight)NativeIO.Windows.AccessRight.ACCESS_READ));
        FileUtil.setWritable((File)testFile, (boolean)false);
        Assert.assertFalse((boolean)NativeIO.Windows.access((String)testFile.getAbsolutePath(), (NativeIO.Windows.AccessRight)NativeIO.Windows.AccessRight.ACCESS_WRITE));
        FileUtil.setWritable((File)testFile, (boolean)true);
        Assert.assertTrue((boolean)NativeIO.Windows.access((String)testFile.getAbsolutePath(), (NativeIO.Windows.AccessRight)NativeIO.Windows.AccessRight.ACCESS_WRITE));
        FileUtil.setExecutable((File)testFile, (boolean)false);
        Assert.assertFalse((boolean)NativeIO.Windows.access((String)testFile.getAbsolutePath(), (NativeIO.Windows.AccessRight)NativeIO.Windows.AccessRight.ACCESS_EXECUTE));
        FileUtil.setExecutable((File)testFile, (boolean)true);
        Assert.assertTrue((boolean)NativeIO.Windows.access((String)testFile.getAbsolutePath(), (NativeIO.Windows.AccessRight)NativeIO.Windows.AccessRight.ACCESS_EXECUTE));
    }

    @Test(timeout=30000L)
    public void testOpenMissingWithoutCreate() throws Exception {
        if (Path.WINDOWS) {
            return;
        }
        LOG.info((Object)"Open a missing file without O_CREAT and it should fail");
        try {
            FileDescriptor fd = NativeIO.POSIX.open((String)new File(TEST_DIR, "doesntexist").getAbsolutePath(), (int)1, (int)448);
            Assert.fail((String)"Able to open a new file without O_CREAT");
        }
        catch (NativeIOException nioe) {
            LOG.info((Object)"Got expected exception", (Throwable)nioe);
            Assert.assertEquals((Object)Errno.ENOENT, (Object)nioe.getErrno());
        }
    }

    @Test(timeout=30000L)
    public void testOpenWithCreate() throws Exception {
        if (Path.WINDOWS) {
            return;
        }
        LOG.info((Object)"Test creating a file with O_CREAT");
        FileDescriptor fd = NativeIO.POSIX.open((String)new File(TEST_DIR, "testWorkingOpen").getAbsolutePath(), (int)65, (int)448);
        Assert.assertNotNull((Object)true);
        Assert.assertTrue((boolean)fd.valid());
        FileOutputStream fos = new FileOutputStream(fd);
        fos.write("foo".getBytes());
        fos.close();
        Assert.assertFalse((boolean)fd.valid());
        LOG.info((Object)"Test exclusive create");
        try {
            fd = NativeIO.POSIX.open((String)new File(TEST_DIR, "testWorkingOpen").getAbsolutePath(), (int)193, (int)448);
            Assert.fail((String)"Was able to create existing file with O_EXCL");
        }
        catch (NativeIOException nioe) {
            LOG.info((Object)"Got expected exception for failed exclusive create", (Throwable)nioe);
            Assert.assertEquals((Object)Errno.EEXIST, (Object)nioe.getErrno());
        }
    }

    @Test(timeout=30000L)
    public void testFDDoesntLeak() throws IOException {
        if (Path.WINDOWS) {
            return;
        }
        for (int i = 0; i < 10000; ++i) {
            FileDescriptor fd = NativeIO.POSIX.open((String)new File(TEST_DIR, "testNoFdLeak").getAbsolutePath(), (int)65, (int)448);
            Assert.assertNotNull((Object)true);
            Assert.assertTrue((boolean)fd.valid());
            FileOutputStream fos = new FileOutputStream(fd);
            fos.write("foo".getBytes());
            fos.close();
        }
    }

    @Test(timeout=30000L)
    public void testChmod() throws Exception {
        if (Path.WINDOWS) {
            return;
        }
        try {
            NativeIO.POSIX.chmod((String)"/this/file/doesnt/exist", (int)777);
            Assert.fail((String)"Chmod of non-existent file didn't fail");
        }
        catch (NativeIOException nioe) {
            Assert.assertEquals((Object)Errno.ENOENT, (Object)nioe.getErrno());
        }
        File toChmod = new File(TEST_DIR, "testChmod");
        Assert.assertTrue((String)"Create test subject", (toChmod.exists() || toChmod.mkdir() ? 1 : 0) != 0);
        NativeIO.POSIX.chmod((String)toChmod.getAbsolutePath(), (int)511);
        this.assertPermissions(toChmod, 511);
        NativeIO.POSIX.chmod((String)toChmod.getAbsolutePath(), (int)0);
        this.assertPermissions(toChmod, 0);
        NativeIO.POSIX.chmod((String)toChmod.getAbsolutePath(), (int)420);
        this.assertPermissions(toChmod, 420);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testPosixFadvise() throws Exception {
        if (Path.WINDOWS) {
            return;
        }
        FileInputStream fis = new FileInputStream("/dev/zero");
        try {
            NativeIO.POSIX.posix_fadvise((FileDescriptor)fis.getFD(), (long)0L, (long)0L, (int)2);
        }
        catch (UnsupportedOperationException uoe) {
            Assume.assumeTrue((boolean)false);
        }
        catch (NativeIOException nioe) {
        }
        finally {
            fis.close();
        }
        try {
            NativeIO.POSIX.posix_fadvise((FileDescriptor)fis.getFD(), (long)0L, (long)1024L, (int)2);
            Assert.fail((String)"Did not throw on bad file");
        }
        catch (NativeIOException nioe) {
            Assert.assertEquals((Object)Errno.EBADF, (Object)nioe.getErrno());
        }
        try {
            NativeIO.POSIX.posix_fadvise(null, (long)0L, (long)1024L, (int)2);
            Assert.fail((String)"Did not throw on null file");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSyncFileRange() throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(TEST_DIR, "testSyncFileRange"));
        try {
            fos.write("foo".getBytes());
            NativeIO.POSIX.sync_file_range((FileDescriptor)fos.getFD(), (long)0L, (long)1024L, (int)2);
        }
        catch (UnsupportedOperationException uoe) {
            Assume.assumeTrue((boolean)false);
        }
        finally {
            fos.close();
        }
        try {
            NativeIO.POSIX.sync_file_range((FileDescriptor)fos.getFD(), (long)0L, (long)1024L, (int)2);
            Assert.fail((String)"Did not throw on bad file");
        }
        catch (NativeIOException nioe) {
            Assert.assertEquals((Object)Errno.EBADF, (Object)nioe.getErrno());
        }
    }

    private void assertPermissions(File f, int expected) throws IOException {
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)new Configuration());
        FsPermission perms = localfs.getFileStatus(new Path(f.getAbsolutePath())).getPermission();
        Assert.assertEquals((long)expected, (long)perms.toShort());
    }

    @Test(timeout=30000L)
    public void testGetUserName() throws IOException {
        if (Path.WINDOWS) {
            return;
        }
        Assert.assertFalse((boolean)NativeIO.POSIX.getUserName((int)0).isEmpty());
    }

    @Test(timeout=30000L)
    public void testGetGroupName() throws IOException {
        if (Path.WINDOWS) {
            return;
        }
        Assert.assertFalse((boolean)NativeIO.POSIX.getGroupName((int)0).isEmpty());
    }

    @Test(timeout=30000L)
    public void testRenameTo() throws Exception {
        File TEST_DIR = new File(new File(System.getProperty("test.build.data", "build/test/data")), "renameTest");
        Assume.assumeTrue((boolean)TEST_DIR.mkdirs());
        File nonExistentFile = new File(TEST_DIR, "nonexistent");
        File targetFile = new File(TEST_DIR, "target");
        try {
            NativeIO.renameTo((File)nonExistentFile, (File)targetFile);
            Assert.fail();
        }
        catch (NativeIOException e) {
            if (Path.WINDOWS) {
                Assert.assertEquals((Object)String.format("The system cannot find the file specified.%n", new Object[0]), (Object)e.getMessage());
            }
            Assert.assertEquals((Object)Errno.ENOENT, (Object)e.getErrno());
        }
        File sourceFile = new File(TEST_DIR, "source");
        Assert.assertTrue((boolean)sourceFile.createNewFile());
        NativeIO.renameTo((File)sourceFile, (File)sourceFile);
        NativeIO.renameTo((File)sourceFile, (File)targetFile);
        sourceFile = new File(TEST_DIR, "source");
        Assert.assertTrue((boolean)sourceFile.createNewFile());
        File badTarget = new File(targetFile, "subdir");
        try {
            NativeIO.renameTo((File)sourceFile, (File)badTarget);
            Assert.fail();
        }
        catch (NativeIOException e) {
            if (Path.WINDOWS) {
                Assert.assertEquals((Object)String.format("The parameter is incorrect.%n", new Object[0]), (Object)e.getMessage());
            }
            Assert.assertEquals((Object)Errno.ENOTDIR, (Object)e.getErrno());
        }
        FileUtils.deleteQuietly((File)TEST_DIR);
    }
}

