/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.file.tfile.KVGenerator;
import org.apache.hadoop.io.file.tfile.KeySampler;
import org.apache.hadoop.io.file.tfile.NanoTimer;
import org.apache.hadoop.io.file.tfile.RandomDistribution;
import org.apache.hadoop.io.file.tfile.TFile;

public class TestTFileSeek
extends TestCase {
    private MyOptions options;
    private Configuration conf;
    private Path path;
    private FileSystem fs;
    private NanoTimer timer;
    private Random rng;
    private RandomDistribution.DiscreteRNG keyLenGen;
    private KVGenerator kvGen;

    public void setUp() throws IOException {
        if (this.options == null) {
            this.options = new MyOptions(new String[0]);
        }
        this.conf = new Configuration();
        this.conf.setInt("tfile.fs.input.buffer.size", this.options.fsInputBufferSize);
        this.conf.setInt("tfile.fs.output.buffer.size", this.options.fsOutputBufferSize);
        this.path = new Path(new Path(this.options.rootDir), this.options.file);
        this.fs = this.path.getFileSystem(this.conf);
        this.timer = new NanoTimer(false);
        this.rng = new Random(this.options.seed);
        this.keyLenGen = new RandomDistribution.Zipf(new Random(this.rng.nextLong()), this.options.minKeyLen, this.options.maxKeyLen, 1.2);
        RandomDistribution.Flat valLenGen = new RandomDistribution.Flat(new Random(this.rng.nextLong()), this.options.minValLength, this.options.maxValLength);
        RandomDistribution.Flat wordLenGen = new RandomDistribution.Flat(new Random(this.rng.nextLong()), this.options.minWordLen, this.options.maxWordLen);
        this.kvGen = new KVGenerator(this.rng, true, this.keyLenGen, valLenGen, wordLenGen, this.options.dictSize);
    }

    public void tearDown() throws IOException {
        this.fs.delete(this.path, true);
    }

    private static FSDataOutputStream createFSOutput(Path name, FileSystem fs) throws IOException {
        if (fs.exists(name)) {
            fs.delete(name, true);
        }
        FSDataOutputStream fout = fs.create(name);
        return fout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTFile() throws IOException {
        long totalBytes = 0L;
        FSDataOutputStream fout = TestTFileSeek.createFSOutput(this.path, this.fs);
        try {
            TFile.Writer writer = new TFile.Writer(fout, this.options.minBlockSize, this.options.compress, "memcmp", this.conf);
            try {
                BytesWritable key = new BytesWritable();
                BytesWritable val = new BytesWritable();
                this.timer.start();
                long i = 0L;
                while (i % 1000L != 0L || this.fs.getFileStatus(this.path).getLen() < this.options.fileSize) {
                    this.kvGen.next(key, val, false);
                    writer.append(key.get(), 0, key.getSize(), val.get(), 0, val.getSize());
                    totalBytes += (long)key.getSize();
                    totalBytes += (long)val.getSize();
                    ++i;
                }
                this.timer.stop();
            }
            finally {
                writer.close();
            }
        }
        finally {
            fout.close();
        }
        double duration = (double)this.timer.read() / 1000.0;
        long fsize = this.fs.getFileStatus(this.path).getLen();
        System.out.printf("time: %s...uncompressed: %.2fMB...raw thrpt: %.2fMB/s\n", this.timer.toString(), (double)totalBytes / 1024.0 / 1024.0, (double)totalBytes / duration);
        System.out.printf("time: %s...file size: %.2fMB...disk thrpt: %.2fMB/s\n", this.timer.toString(), (double)fsize / 1024.0 / 1024.0, (double)fsize / duration);
    }

    public void seekTFile() throws IOException {
        int miss = 0;
        long totalBytes = 0L;
        FSDataInputStream fsdis = this.fs.open(this.path);
        TFile.Reader reader = new TFile.Reader(fsdis, this.fs.getFileStatus(this.path).getLen(), this.conf);
        KeySampler kSampler = new KeySampler(this.rng, reader.getFirstKey(), reader.getLastKey(), this.keyLenGen);
        TFile.Reader.Scanner scanner = reader.createScanner();
        BytesWritable key = new BytesWritable();
        BytesWritable val = new BytesWritable();
        this.timer.reset();
        this.timer.start();
        int i = 0;
        while ((long)i < this.options.seekCount) {
            kSampler.next(key);
            scanner.lowerBound(key.get(), 0, key.getSize());
            if (!scanner.atEnd()) {
                scanner.entry().get(key, val);
                totalBytes += (long)key.getSize();
                totalBytes += (long)val.getSize();
            } else {
                ++miss;
            }
            ++i;
        }
        this.timer.stop();
        double duration = (double)this.timer.read() / 1000.0;
        System.out.printf("time: %s...avg seek: %s...%d hit...%d miss...avg I/O size: %.2fKB\n", this.timer.toString(), NanoTimer.nanoTimeToString(this.timer.read() / this.options.seekCount), this.options.seekCount - (long)miss, miss, (double)totalBytes / 1024.0 / (double)(this.options.seekCount - (long)miss));
    }

    public void testSeeks() throws IOException {
        String[] supported = TFile.getSupportedCompressionAlgorithms();
        boolean proceed = false;
        for (String c : supported) {
            if (!c.equals(this.options.compress)) continue;
            proceed = true;
            break;
        }
        if (!proceed) {
            System.out.println("Skipped for " + this.options.compress);
            return;
        }
        if (this.options.doCreate()) {
            this.createTFile();
        }
        if (this.options.doRead()) {
            this.seekTFile();
        }
    }

    public static void main(String[] argv) throws IOException {
        TestTFileSeek testCase = new TestTFileSeek();
        MyOptions options = new MyOptions(argv);
        if (!options.proceed) {
            return;
        }
        testCase.options = options;
        testCase.setUp();
        testCase.testSeeks();
        testCase.tearDown();
    }

    private static class MyOptions {
        int dictSize = 1000;
        int minWordLen = 5;
        int maxWordLen = 20;
        int osInputBufferSize = 65536;
        int osOutputBufferSize = 65536;
        int fsInputBufferSizeNone = 0;
        int fsInputBufferSizeLzo = 0;
        int fsInputBufferSizeGz = 0;
        int fsOutputBufferSizeNone = 1;
        int fsOutputBufferSizeLzo = 1;
        int fsOutputBufferSizeGz = 1;
        String rootDir = System.getProperty("test.build.data", "/tmp/tfile-test");
        String file = "TestTFileSeek";
        String compress = "gz";
        int minKeyLen = 10;
        int maxKeyLen = 50;
        int minValLength = 100;
        int maxValLength = 200;
        int minBlockSize = 65536;
        int fsOutputBufferSize = 1;
        int fsInputBufferSize = 0;
        long fileSize = 0x300000L;
        long seekCount = 1000L;
        long seed = System.nanoTime();
        static final int OP_CREATE = 1;
        static final int OP_READ = 2;
        int op = 3;
        boolean proceed = false;

        public MyOptions(String[] args) {
            try {
                Options opts = this.buildOptions();
                GnuParser parser = new GnuParser();
                CommandLine line = parser.parse(opts, args, true);
                this.processOptions(line, opts);
                this.validateOptions();
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
                System.out.println("Try \"--help\" option for details.");
                this.setStopProceed();
            }
        }

        public boolean proceed() {
            return this.proceed;
        }

        private Options buildOptions() {
            OptionBuilder.withLongOpt((String)"compress");
            OptionBuilder.withArgName((String)"[none|lzo|gz]");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"compression scheme");
            Option compress = OptionBuilder.create((char)'c');
            OptionBuilder.withLongOpt((String)"file-size");
            OptionBuilder.withArgName((String)"size-in-MB");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"target size of the file (in MB).");
            Option fileSize = OptionBuilder.create((char)'s');
            OptionBuilder.withLongOpt((String)"fs-input-buffer");
            OptionBuilder.withArgName((String)"size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"size of the file system input buffer (in bytes).");
            Option fsInputBufferSz = OptionBuilder.create((char)'i');
            OptionBuilder.withLongOpt((String)"fs-output-buffer");
            OptionBuilder.withArgName((String)"size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"size of the file system output buffer (in bytes).");
            Option fsOutputBufferSize = OptionBuilder.create((char)'o');
            OptionBuilder.withLongOpt((String)"key-length");
            OptionBuilder.withArgName((String)"min,max");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the length range of the key (in bytes)");
            Option keyLen = OptionBuilder.create((char)'k');
            OptionBuilder.withLongOpt((String)"value-length");
            OptionBuilder.withArgName((String)"min,max");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the length range of the value (in bytes)");
            Option valueLen = OptionBuilder.create((char)'v');
            OptionBuilder.withLongOpt((String)"block");
            OptionBuilder.withArgName((String)"size-in-KB");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"minimum block size (in KB)");
            Option blockSz = OptionBuilder.create((char)'b');
            OptionBuilder.withLongOpt((String)"seed");
            OptionBuilder.withArgName((String)"long-int");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify the seed");
            Option seed = OptionBuilder.create((char)'S');
            OptionBuilder.withLongOpt((String)"operation");
            OptionBuilder.withArgName((String)"r|w|rw");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"action: seek-only, create-only, seek-after-create");
            Option operation = OptionBuilder.create((char)'x');
            OptionBuilder.withLongOpt((String)"root-dir");
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify root directory where files will be created.");
            Option rootDir = OptionBuilder.create((char)'r');
            OptionBuilder.withLongOpt((String)"file");
            OptionBuilder.withArgName((String)"name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify the file name to be created or read.");
            Option file = OptionBuilder.create((char)'f');
            OptionBuilder.withLongOpt((String)"seek");
            OptionBuilder.withArgName((String)"count");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify how many seek operations we perform (requires -x r or -x rw.");
            Option seekCount = OptionBuilder.create((char)'n');
            OptionBuilder.withLongOpt((String)"help");
            OptionBuilder.hasArg((boolean)false);
            OptionBuilder.withDescription((String)"show this screen");
            Option help = OptionBuilder.create((String)"h");
            return new Options().addOption(compress).addOption(fileSize).addOption(fsInputBufferSz).addOption(fsOutputBufferSize).addOption(keyLen).addOption(blockSz).addOption(rootDir).addOption(valueLen).addOption(operation).addOption(seekCount).addOption(file).addOption(help);
        }

        private void processOptions(CommandLine line, Options opts) throws ParseException {
            IntegerRange ir;
            if (line.hasOption('h')) {
                HelpFormatter formatter = new HelpFormatter();
                System.out.println("TFile and SeqFile benchmark.");
                System.out.println();
                formatter.printHelp(100, "java ... TestTFileSeqFileComparison [options]", "\nSupported options:", opts, "");
                return;
            }
            if (line.hasOption('c')) {
                this.compress = line.getOptionValue('c');
            }
            if (line.hasOption('d')) {
                this.dictSize = Integer.parseInt(line.getOptionValue('d'));
            }
            if (line.hasOption('s')) {
                this.fileSize = Long.parseLong(line.getOptionValue('s')) * 1024L * 1024L;
            }
            if (line.hasOption('i')) {
                this.fsInputBufferSize = Integer.parseInt(line.getOptionValue('i'));
            }
            if (line.hasOption('o')) {
                this.fsOutputBufferSize = Integer.parseInt(line.getOptionValue('o'));
            }
            if (line.hasOption('n')) {
                this.seekCount = Integer.parseInt(line.getOptionValue('n'));
            }
            if (line.hasOption('k')) {
                ir = IntegerRange.parse(line.getOptionValue('k'));
                this.minKeyLen = ir.from();
                this.maxKeyLen = ir.to();
            }
            if (line.hasOption('v')) {
                ir = IntegerRange.parse(line.getOptionValue('v'));
                this.minValLength = ir.from();
                this.maxValLength = ir.to();
            }
            if (line.hasOption('b')) {
                this.minBlockSize = Integer.parseInt(line.getOptionValue('b')) * 1024;
            }
            if (line.hasOption('r')) {
                this.rootDir = line.getOptionValue('r');
            }
            if (line.hasOption('f')) {
                this.file = line.getOptionValue('f');
            }
            if (line.hasOption('S')) {
                this.seed = Long.parseLong(line.getOptionValue('S'));
            }
            if (line.hasOption('x')) {
                String strOp = line.getOptionValue('x');
                if (strOp.equals("r")) {
                    this.op = 2;
                } else if (strOp.equals("w")) {
                    this.op = 1;
                } else if (strOp.equals("rw")) {
                    this.op = 3;
                } else {
                    throw new ParseException("Unknown action specifier: " + strOp);
                }
            }
            this.proceed = true;
        }

        private void validateOptions() throws ParseException {
            if (!(this.compress.equals("none") || this.compress.equals("lzo") || this.compress.equals("gz"))) {
                throw new ParseException("Unknown compression scheme: " + this.compress);
            }
            if (this.minKeyLen >= this.maxKeyLen) {
                throw new ParseException("Max key length must be greater than min key length.");
            }
            if (this.minValLength >= this.maxValLength) {
                throw new ParseException("Max value length must be greater than min value length.");
            }
            if (this.minWordLen >= this.maxWordLen) {
                throw new ParseException("Max word length must be greater than min word length.");
            }
        }

        private void setStopProceed() {
            this.proceed = false;
        }

        public boolean doCreate() {
            return (this.op & 1) != 0;
        }

        public boolean doRead() {
            return (this.op & 2) != 0;
        }
    }

    private static class IntegerRange {
        private final int from;
        private final int to;

        public IntegerRange(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public static IntegerRange parse(String s) throws ParseException {
            StringTokenizer st = new StringTokenizer(s, " \t,");
            if (st.countTokens() != 2) {
                throw new ParseException("Bad integer specification: " + s);
            }
            int from = Integer.parseInt(st.nextToken());
            int to = Integer.parseInt(st.nextToken());
            return new IntegerRange(from, to);
        }

        public int from() {
            return this.from;
        }

        public int to() {
            return this.to;
        }
    }
}

