/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.net.URISyntaxException;

public class ClusterMetaData
implements Externalizable {
    private URI[] locations;
    private long version;
    private String connectionStrategy;
    private URI lastLocation;

    public ClusterMetaData() {
    }

    public ClusterMetaData(long version, URI ... locations) {
        this.locations = locations;
        this.version = version;
    }

    public URI getLastLocation() {
        return this.lastLocation;
    }

    public void setLastLocation(URI lastLocation) {
        this.lastLocation = lastLocation;
    }

    public URI[] getLocations() {
        return this.locations;
    }

    public long getVersion() {
        return this.version;
    }

    public String getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.version = in.readLong();
        this.connectionStrategy = (String)in.readObject();
        int length = in.readInt();
        this.locations = new URI[length];
        for (int i = 0; i < this.locations.length; ++i) {
            Object o = in.readObject();
            try {
                this.locations[i] = new URI((String)o);
                continue;
            }
            catch (URISyntaxException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeLong(this.version);
        out.writeObject(this.connectionStrategy);
        out.writeInt(this.locations.length);
        for (URI uri : this.locations) {
            out.writeObject(uri.toString());
        }
    }
}

