/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.openejb.client.DataSourceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientDataSource
implements DataSource {
    private final String jdbcUrl;
    private final String defaultPassword;
    private final String defaultUserName;

    public static void main(String[] args) throws URISyntaxException {
        URI uri1 = new URI("datasource", null, "/path", null, null);
        uri1 = new URI("datasource", null, "/path", null, null);
        System.out.println("uri = " + uri1);
        uri1 = new URI("datasource", "host", "/path", null, null);
        System.out.println("uri = " + uri1);
        uri1 = new URI("datasource", "host", "/path", "query", "fragment");
        System.out.println("uri = " + uri1);
        uri1 = new URI("jdbc:derby://localhost:8080/databaseName");
        ClientDataSource.print(uri1);
        ClientDataSource.print(new URI(uri1.getSchemeSpecificPart()));
    }

    private static void print(URI uri1) {
        System.out.println("uri = " + uri1);
        System.out.println("  scheme = " + uri1.getScheme());
        System.out.println("  part   = " + uri1.getSchemeSpecificPart());
        System.out.println("  host   = " + uri1.getHost());
        System.out.println("  path   = " + uri1.getPath());
        System.out.println("  query  = " + uri1.getQuery());
    }

    public ClientDataSource(DataSourceMetaData d) {
        this(d.getJdbcDriver(), d.getJdbcUrl(), d.getDefaultUserName(), d.getDefaultPassword());
    }

    public ClientDataSource(String jdbcDriver, String jdbcUrl, String defaultUserName, String defaultPassword) {
        this.defaultPassword = defaultPassword;
        this.defaultUserName = defaultUserName;
        this.jdbcUrl = jdbcUrl;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class.forName(jdbcDriver, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot use DataSource in client VM without the JDBC Driver in classpath: " + jdbcDriver, e);
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Cannot use DataSource in client VM without the JDBC Driver in classpath: " + jdbcDriver, e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.defaultUserName, this.defaultPassword);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(this.jdbcUrl, username, password);
        return connection;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        if (iface == null) {
            throw new NullPointerException("iface is null");
        }
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new NullPointerException("iface is null");
        }
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException(this.getClass().getName() + " does not implement " + iface.getName());
    }
}

