/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.LdapMessageHandler;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddHandler
implements LdapMessageHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)AddHandler.class);
    private static Control[] EMPTY_CONTROLS = new Control[0];
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public void messageReceived(IoSession session, Object request) {
        AddRequest req = (AddRequest)request;
        LdapResult result = req.getResultResponse().getLdapResult();
        if (IS_DEBUG) {
            log.debug("Received a Add message : " + req.toString());
        }
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                ctx.addToEnvironment("java.naming.referral", "ignore");
            } else {
                ctx.addToEnvironment("java.naming.referral", "throw");
            }
            ctx.setRequestControls((javax.naming.ldap.Control[])req.getControls().values().toArray(EMPTY_CONTROLS));
            ctx.createSubcontext((Name)req.getEntry(), req.getAttributes());
        }
        catch (ReferralException e) {
            ReferralImpl refs = new ReferralImpl();
            result.setReferral((Referral)refs);
            result.setResultCode(ResultCodeEnum.REFERRAL);
            result.setErrorMessage("Encountered referral attempting to handle add request.");
            do {
                refs.addLdapUrl((String)e.getReferralInfo());
            } while (e.skipReferral());
            session.write((Object)req.getResultResponse());
            return;
        }
        catch (NamingException e) {
            String msg = "failed to add entry " + req.getEntry() + ": " + e.getMessage();
            if (log.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            result.setResultCode(code);
            result.setErrorMessage(msg);
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            session.write((Object)req.getResultResponse());
            return;
        }
        result.setResultCode(ResultCodeEnum.SUCCESS);
        session.write((Object)req.getResultResponse());
    }

    public void init(StartupConfiguration cfg) {
    }
}

