/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ShutdownProgress
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JButton jButton = null;
    private JProgressBar jProgressBar = null;
    private long timeMillis = 0L;
    private boolean bypass = false;

    public void setTime(long millis) {
        this.timeMillis = millis;
    }

    public void run() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jProgressBar.setEnabled(true);
        this.jProgressBar.setMinimum(0);
        this.jProgressBar.setMaximum((int)this.timeMillis);
        this.jProgressBar.setValue(0);
        this.jProgressBar.setStringPainted(true);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.timeMillis && !this.bypass) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.jProgressBar.setString((this.timeMillis - (System.currentTimeMillis() - startTime)) / 1000L + " seconds remaining ...");
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 100);
            this.repaint();
        }
        this.setCursor(null);
        this.setVisible(false);
        this.dispose();
    }

    public ShutdownProgress() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 104);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "South");
            this.jContentPane.add((Component)this.getJProgressBar(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJButton(), null);
        }
        return this.jPanel;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Bypass Delay");
            this.jButton.setText("Bypass Delay");
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShutdownProgress.this.bypass = true;
                }
            });
        }
        return this.jButton;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
        }
        return this.jProgressBar;
    }
}

