/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.mina.common.IoSession;

public class SessionRegistry {
    private static SessionRegistry s_singleton;
    private final Map contexts = new HashMap();
    private final Map requests = new HashMap();
    private Hashtable env;

    public static SessionRegistry getSingleton() {
        if (s_singleton == null) {
            s_singleton = new SessionRegistry(new Hashtable());
        }
        return s_singleton;
    }

    static void releaseSingleton() {
        s_singleton = null;
    }

    SessionRegistry(Hashtable env) {
        if (s_singleton != null) {
            throw new IllegalStateException("there can only be one singlton");
        }
        s_singleton = this;
        if (env == null) {
            this.env = new Hashtable();
            this.env.put("java.naming.provider.url", "");
            this.env.put("java.naming.factory.initial", "org.apache.directory.server.jndi.ServerContextFactory");
        } else {
            this.env = env;
            this.env.put("java.naming.provider.url", "");
        }
    }

    public Hashtable getEnvironmentByCopy() {
        return (Hashtable)this.env.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutstandingRequest(IoSession session, Request req) {
        Map map = this.requests;
        synchronized (map) {
            HashMap<Integer, Request> reqmap = (HashMap<Integer, Request>)this.requests.get(session);
            if (reqmap == null) {
                reqmap = new HashMap<Integer, Request>();
                this.requests.put(session, reqmap);
            }
            reqmap.put(new Integer(req.getMessageId()), req);
        }
    }

    public Request removeOutstandingRequest(IoSession session, int messageId) {
        return this.removeOutstandingRequest(session, new Integer(messageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request removeOutstandingRequest(IoSession session, Integer id) {
        Map map = this.requests;
        synchronized (map) {
            Map reqmap = (Map)this.requests.get(session);
            if (reqmap == null) {
                return null;
            }
            return (Request)reqmap.remove(id);
        }
    }

    public Map getOutstandingRequests(IoSession session) {
        Map reqmap = (Map)this.requests.get(session);
        if (reqmap == null) {
            return Collections.EMPTY_MAP;
        }
        return new HashMap(reqmap);
    }

    public Request getOutstandingRequest(IoSession session, int abandonedId) {
        return this.getOutstandingRequest(session, new Integer(abandonedId));
    }

    public Request getOutstandingRequest(IoSession session, Integer id) {
        Map reqmap = (Map)this.requests.get(session);
        if (reqmap == null) {
            return null;
        }
        return (Request)reqmap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession[] getSessions() {
        IoSession[] sessions;
        Map map = this.contexts;
        synchronized (map) {
            sessions = new IoSession[this.contexts.size()];
            sessions = this.contexts.keySet().toArray(sessions);
        }
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext getLdapContext(IoSession session, Control[] connCtls, boolean allowAnonymous) throws NamingException {
        LdapContext ctx = null;
        Map map = this.contexts;
        synchronized (map) {
            ctx = (LdapContext)this.contexts.get(session);
        }
        if (ctx == null && allowAnonymous) {
            StartupConfiguration config = (StartupConfiguration)Configuration.toConfiguration((Hashtable)this.env);
            if (!config.isAllowAnonymousAccess()) {
                throw new LdapNoPermissionException("Anonymous binds have been disabled!");
            }
            if (this.env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)this.env.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(this.env);
            } else {
                Hashtable cloned = (Hashtable)this.env.clone();
                cloned.put("java.naming.security.authentication", "none");
                cloned.remove("java.naming.security.principal");
                cloned.remove("java.naming.security.credentials");
                ctx = new InitialLdapContext(cloned, connCtls);
            }
        } else if (ctx != null && allowAnonymous) {
            ServerLdapContext slc = null;
            slc = !(ctx instanceof ServerLdapContext) ? (ServerLdapContext)ctx.lookup("") : (ServerLdapContext)ctx;
            boolean isAnonymousUser = slc.getPrincipal().getName().trim().equals("");
            StartupConfiguration cfg = (StartupConfiguration)Configuration.toConfiguration((Hashtable)this.env);
            if (isAnonymousUser && !cfg.isAllowAnonymousAccess()) {
                throw new LdapNoPermissionException("Anonymous binds have been disabled!");
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext getLdapContextOnRootDSEAccess(IoSession session, Control[] connCtls) throws NamingException {
        LdapContext ctx = null;
        Map map = this.contexts;
        synchronized (map) {
            ctx = (LdapContext)this.contexts.get(session);
        }
        if (ctx == null) {
            if (this.env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)this.env.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(this.env);
            } else {
                Hashtable cloned = (Hashtable)this.env.clone();
                cloned.put("java.naming.security.authentication", "none");
                cloned.remove("java.naming.security.principal");
                cloned.remove("java.naming.security.credentials");
                ctx = new InitialLdapContext(cloned, connCtls);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLdapContext(IoSession session, LdapContext ictx) {
        Map map = this.contexts;
        synchronized (map) {
            this.contexts.put(session, ictx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IoSession session) {
        Map map = this.contexts;
        synchronized (map) {
            this.contexts.remove(session);
        }
        Map reqmap = null;
        Map map2 = this.requests;
        synchronized (map2) {
            reqmap = (Map)this.requests.remove(session);
        }
        if (reqmap == null || reqmap.isEmpty()) {
            return;
        }
        Iterator list = reqmap.values().iterator();
        while (list.hasNext()) {
            Object request = list.next();
            if (!(request instanceof AbandonableRequest)) continue;
            ((AbandonableRequest)request).abandon();
        }
    }

    public void terminateSession(IoSession session) {
        session.close();
    }
}

