/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.entryChange;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.asn1.util.LongDecoder;
import org.apache.directory.shared.asn1.util.LongDecoderException;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.codec.search.controls.entryChange.EntryChangeControlCodec;
import org.apache.directory.shared.ldap.codec.search.controls.entryChange.EntryChangeControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.entryChange.EntryChangeControlStatesEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryChangeControlGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(EntryChangeControlGrammar.class);
    static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new EntryChangeControlGrammar();

    private EntryChangeControlGrammar() {
        this.name = EntryChangeControlGrammar.class.getName();
        this.statesEnum = EntryChangeControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[5][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, new GrammarAction("Init EntryChangeControl"){

            public void action(IAsn1Container container) {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                EntryChangeControlCodec control = new EntryChangeControlCodec();
                entryChangeContainer.setEntryChangeControl(control);
            }
        });
        this.transitions[1][10] = new GrammarTransition(1, 2, 10, new GrammarAction("Set EntryChangeControl changeType"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                try {
                    int change = IntegerDecoder.parse(value, 1, 8);
                    switch (change) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            ChangeType changeType = ChangeType.getChangeType(change);
                            if (IS_DEBUG) {
                                log.debug("changeType = " + changeType);
                            }
                            entryChangeContainer.getEntryChangeControl().setChangeType(changeType);
                            break;
                        }
                        default: {
                            String msg = "failed to decode the changeType for EntryChangeControl";
                            log.error(msg);
                            throw new DecoderException(msg);
                        }
                    }
                    entryChangeContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the changeType for EntryChangeControl";
                    log.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[2][4] = new GrammarTransition(2, 3, 4, new GrammarAction("Set EntryChangeControl previousDN"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                ChangeType changeType = entryChangeContainer.getEntryChangeControl().getChangeType();
                if (changeType != ChangeType.MODDN) {
                    log.error("The previousDN field should not contain anything if the changeType is not MODDN");
                    throw new DecoderException("Previous DN is not allowed for this change type");
                }
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                LdapDN previousDn = null;
                try {
                    previousDn = new LdapDN(StringTools.utf8ToString(value.getData()));
                }
                catch (InvalidNameException ine) {
                    log.error("Bad Previous DN : '" + StringTools.dumpBytes(value.getData()));
                    throw new DecoderException("failed to decode the previous DN");
                }
                if (IS_DEBUG) {
                    log.debug("previousDN = " + previousDn);
                }
                entryChangeContainer.getEntryChangeControl().setPreviousDn(previousDn);
                entryChangeContainer.grammarEndAllowed(true);
            }
        });
        GrammarAction setChangeNumberAction = new GrammarAction("Set EntryChangeControl changeNumber"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                try {
                    long changeNumber = LongDecoder.parse(value);
                    if (IS_DEBUG) {
                        log.debug("changeNumber = " + changeNumber);
                    }
                    entryChangeContainer.getEntryChangeControl().setChangeNumber(changeNumber);
                    entryChangeContainer.grammarEndAllowed(true);
                }
                catch (LongDecoderException e) {
                    String msg = "failed to decode the changeNumber for EntryChangeControl";
                    log.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        };
        this.transitions[3][2] = new GrammarTransition(3, 4, 2, setChangeNumberAction);
        this.transitions[2][2] = new GrammarTransition(2, 4, 2, setChangeNumberAction);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

