/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureRequestContainer;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureParameter;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureRequest;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureRequestImpl;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureResponse;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;

public class StoredProcedureFactory
extends AbstractExtendedOperationFactory {
    public StoredProcedureFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.4.1.18060.0.1.6");
    }

    public StoredProcedureRequest newRequest() {
        return new StoredProcedureRequestImpl();
    }

    public StoredProcedureRequest newRequest(byte[] value) throws DecoderException {
        StoredProcedureRequestImpl storedProcedureRequest = new StoredProcedureRequestImpl();
        this.decodeValue((ExtendedRequest)storedProcedureRequest, value);
        return storedProcedureRequest;
    }

    public StoredProcedureResponse newResponse() {
        return new StoredProcedureResponseImpl();
    }

    public void decodeValue(ExtendedRequest extendedRequest, byte[] requestValue) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(requestValue);
        StoredProcedureRequestContainer container = new StoredProcedureRequestContainer();
        container.setStoredProcedureRequest((StoredProcedureRequest)extendedRequest);
        Asn1Decoder.decode((ByteBuffer)bb, (Asn1Container)container);
    }

    private void encodeParameters(Asn1Buffer buffer, Iterator<StoredProcedureParameter> parameters) {
        if (parameters.hasNext()) {
            StoredProcedureParameter parameter = parameters.next();
            this.encodeParameters(buffer, parameters);
            int start = buffer.getPos();
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])parameter.getValue());
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])parameter.getType());
            BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
        }
    }

    public void encodeValue(Asn1Buffer buffer, ExtendedRequest extendedRequest) {
        int start = buffer.getPos();
        StoredProcedureRequest storedProcedureRequest = (StoredProcedureRequest)extendedRequest;
        this.encodeParameters(buffer, storedProcedureRequest.getParameters().iterator());
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
        BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])storedProcedureRequest.getProcedure());
        BerValue.encodeOctetString((Asn1Buffer)buffer, (String)storedProcedureRequest.getLanguage());
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
    }
}

