/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCollector {
    private final Map<String, String> seiClassNames = new HashMap<String, String>();
    private final Map<String, String> typesClassNames = new HashMap<String, String>();
    private final Map<String, String> exceptionClassNames = new HashMap<String, String>();
    private final Map<String, String> serviceClassNames = new HashMap<String, String>();
    private final Map<String, String> implClassNames = new HashMap<String, String>();
    private final Map<String, String> clientClassNames = new HashMap<String, String>();
    private final Map<String, String> serverClassNames = new HashMap<String, String>();
    private final Set<String> typesPackages = new HashSet<String>();

    public boolean containSeiClass(String packagename, String type) {
        return this.seiClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containTypesClass(String packagename, String type) {
        return this.typesClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containExceptionClass(String packagename, String type) {
        return this.exceptionClassNames.containsKey(this.key(packagename, type));
    }

    public void addSeiClassName(String packagename, String type, String fullClassName) {
        this.seiClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addTypesClassName(String packagename, String type, String fullClassName) {
        this.typesClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addServerClassName(String packagename, String type, String fullClassName) {
        this.serverClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addImplClassName(String packagename, String type, String fullClassName) {
        this.implClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addClientClassName(String packagename, String type, String fullClassName) {
        this.clientClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addServiceClassName(String packagename, String type, String fullClassName) {
        this.serviceClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addExceptionClassName(String packagename, String type, String fullClassName) {
        this.exceptionClassNames.put(this.key(packagename, type), fullClassName);
    }

    public String getTypesFullClassName(String packagename, String type) {
        return this.typesClassNames.get(this.key(packagename, type));
    }

    private String key(String packagename, String type) {
        return packagename + "#" + type;
    }

    public Set<String> getTypesPackages() {
        return this.typesPackages;
    }

    public List<String> getGeneratedFileInfo() {
        ArrayList<String> generatedFileList = new ArrayList<String>();
        generatedFileList.addAll(this.seiClassNames.values());
        generatedFileList.addAll(this.typesClassNames.values());
        generatedFileList.addAll(this.exceptionClassNames.values());
        generatedFileList.addAll(this.serviceClassNames.values());
        generatedFileList.addAll(this.implClassNames.values());
        generatedFileList.addAll(this.clientClassNames.values());
        return generatedFileList;
    }
}

