/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomEntryParser {
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_TITLE = "title";
    private static final String TAG_OBJECT = "object";
    private static final String TAG_CONTENT = "content";
    private static final String TAG_BASE64 = "base64";
    private static final String TAG_MEDIATYPE = "mediatype";
    private static final String ATTR_SRC = "src";
    private static final String ATTR_TYPE = "type";
    protected boolean ignoreAtomContentSrc;
    private ObjectData object;
    private ContentStreamImpl atomContentStream;
    private ContentStreamImpl cmisContentStream;

    public AtomEntryParser() {
    }

    public AtomEntryParser(InputStream stream) throws Exception {
        this.parse(stream);
    }

    public void setIgnoreAtomContentSrc(boolean ignoreAtomContentSrc) {
        this.ignoreAtomContentSrc = ignoreAtomContentSrc;
    }

    public ObjectData getObject() {
        return this.object;
    }

    public Properties getProperties() {
        return this.object == null ? null : this.object.getProperties();
    }

    public String getId() {
        Properties properties = this.getProperties();
        if (properties == null) {
            return null;
        }
        Map propertiesMap = properties.getProperties();
        if (propertiesMap == null) {
            return null;
        }
        PropertyData property = (PropertyData)propertiesMap.get("cmis:objectId");
        if (property instanceof PropertyId) {
            return (String)((PropertyId)property).getFirstValue();
        }
        return null;
    }

    public Acl getAcl() {
        return this.object == null ? null : this.object.getAcl();
    }

    public List<String> getPolicyIds() {
        if (this.object == null || this.object.getPolicyIds() == null) {
            return null;
        }
        return this.object.getPolicyIds().getPolicyIds();
    }

    public ContentStream getContentStream() {
        return this.cmisContentStream == null ? this.atomContentStream : this.cmisContentStream;
    }

    public void parse(InputStream stream) throws Exception {
        this.object = null;
        this.atomContentStream = null;
        this.cmisContentStream = null;
        if (stream == null) {
            return;
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        XMLStreamReader parser = factory.createXMLStreamReader(stream);
        do {
            int event;
            if ((event = parser.getEventType()) != 1) continue;
            QName name = parser.getName();
            if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI()) && TAG_ENTRY.equals(name.getLocalPart())) {
                this.parseEntry(parser);
                break;
            }
            throw new CmisInvalidArgumentException("XML is not an Atom entry!");
        } while (AtomEntryParser.next(parser));
        parser.close();
    }

    private void parseEntry(XMLStreamReader parser) throws Exception {
        String atomTitle = null;
        AtomEntryParser.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if (TAG_OBJECT.equals(name.getLocalPart())) {
                        this.parseObject(parser);
                        continue;
                    }
                    if (TAG_CONTENT.equals(name.getLocalPart())) {
                        this.parseCmisContent(parser);
                        continue;
                    }
                    AtomEntryParser.skip(parser);
                    continue;
                }
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if (TAG_CONTENT.equals(name.getLocalPart())) {
                        this.parseAtomContent(parser);
                        continue;
                    }
                    if (TAG_TITLE.equals(name.getLocalPart())) {
                        atomTitle = AtomEntryParser.readText(parser);
                        continue;
                    }
                    AtomEntryParser.skip(parser);
                    continue;
                }
                AtomEntryParser.skip(parser);
                continue;
            }
            if (event == 2 || !AtomEntryParser.next(parser)) break;
        }
        if (this.object != null && this.object.getProperties() != null && atomTitle != null && atomTitle.length() > 0) {
            PropertyStringImpl nameProperty = new PropertyStringImpl("cmis:name", atomTitle);
            ((PropertiesImpl)this.object.getProperties()).replaceProperty((PropertyData)nameProperty);
        }
    }

    private void parseObject(XMLStreamReader parser) throws Exception {
        Unmarshaller u = JaxBHelper.createUnmarshaller();
        JAXBElement jaxbObject = u.unmarshal(parser, CmisObjectType.class);
        if (jaxbObject != null) {
            this.object = Converter.convert((CmisObjectType)((CmisObjectType)jaxbObject.getValue()));
        }
    }

    private void parseAtomContent(XMLStreamReader parser) throws Exception {
        this.atomContentStream = new ContentStreamImpl();
        String type = "text";
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            QName attrName = parser.getAttributeName(i);
            if (ATTR_TYPE.equals(attrName.getLocalPart())) {
                this.atomContentStream.setMimeType(parser.getAttributeValue(i));
                if (parser.getAttributeValue(i) == null) continue;
                type = parser.getAttributeValue(i).trim().toLowerCase();
                continue;
            }
            if (!ATTR_SRC.equals(attrName.getLocalPart())) continue;
            if (this.ignoreAtomContentSrc) {
                this.atomContentStream = null;
                AtomEntryParser.skip(parser);
                return;
            }
            throw new CmisNotSupportedException("External content not supported!");
        }
        byte[] bytes = null;
        if (type.equals("text") || type.equals("html")) {
            bytes = AtomEntryParser.readText(parser).getBytes("UTF-8");
        } else if (type.equals("xhtml")) {
            bytes = AtomEntryParser.copy(parser);
        } else if (type.endsWith("/xml") || type.endsWith("+xml")) {
            bytes = AtomEntryParser.copy(parser);
        } else if (type.startsWith("text/")) {
            bytes = AtomEntryParser.readText(parser).getBytes("UTF-8");
        } else {
            ThresholdOutputStream ths = AtomEntryParser.readBase64(parser);
            this.atomContentStream.setStream(ths.getInputStream());
            this.atomContentStream.setLength(BigInteger.valueOf(ths.getSize()));
        }
        if (bytes != null) {
            this.atomContentStream.setStream((InputStream)new ByteArrayInputStream(bytes));
            this.atomContentStream.setLength(BigInteger.valueOf(bytes.length));
        }
    }

    private void parseCmisContent(XMLStreamReader parser) throws Exception {
        this.cmisContentStream = new ContentStreamImpl();
        AtomEntryParser.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if (TAG_MEDIATYPE.equals(name.getLocalPart())) {
                        this.cmisContentStream.setMimeType(AtomEntryParser.readText(parser));
                        continue;
                    }
                    if (TAG_BASE64.equals(name.getLocalPart())) {
                        ThresholdOutputStream ths = AtomEntryParser.readBase64(parser);
                        this.cmisContentStream.setStream(ths.getInputStream());
                        this.cmisContentStream.setLength(BigInteger.valueOf(ths.getSize()));
                        continue;
                    }
                    AtomEntryParser.skip(parser);
                    continue;
                }
                AtomEntryParser.skip(parser);
                continue;
            }
            if (event == 2 || !AtomEntryParser.next(parser)) break;
        }
        AtomEntryParser.next(parser);
    }

    private static String readText(XMLStreamReader parser) throws Exception {
        int event;
        StringBuilder sb = new StringBuilder();
        AtomEntryParser.next(parser);
        while ((event = parser.getEventType()) != 2) {
            if (event == 4) {
                String s = parser.getText();
                if (s != null) {
                    sb.append(s);
                }
            } else if (event == 1) {
                throw new RuntimeException("Unexpected tag: " + parser.getName());
            }
            if (AtomEntryParser.next(parser)) continue;
            break;
        }
        AtomEntryParser.next(parser);
        return sb.toString();
    }

    private static ThresholdOutputStream readBase64(XMLStreamReader parser) throws Exception {
        int event;
        ThresholdOutputStream bufferStream = new ThresholdOutputStream();
        Base64.OutputStream b64stream = new Base64.OutputStream((OutputStream)bufferStream, 0);
        AtomEntryParser.next(parser);
        while ((event = parser.getEventType()) != 2) {
            if (event == 4) {
                String s = parser.getText();
                if (s != null) {
                    b64stream.write(s.getBytes("US-ASCII"));
                }
            } else if (event == 1) {
                throw new RuntimeException("Unexpected tag: " + parser.getName());
            }
            if (AtomEntryParser.next(parser)) continue;
            break;
        }
        b64stream.close();
        AtomEntryParser.next(parser);
        return bufferStream;
    }

    private static byte[] copy(XMLStreamReader parser) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
        writer.writeStartDocument();
        int level = 1;
        while (AtomEntryParser.next(parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                AtomEntryParser.copyStartElement(parser, writer);
                ++level;
                continue;
            }
            if (event == 4) {
                writer.writeCharacters(parser.getText());
                continue;
            }
            if (event == 5) {
                writer.writeComment(parser.getText());
                continue;
            }
            if (event == 12) {
                writer.writeCData(parser.getText());
                continue;
            }
            if (event != 2 || --level == 0) break;
            writer.writeEndElement();
        }
        writer.writeEndDocument();
        AtomEntryParser.next(parser);
        return out.toByteArray();
    }

    private static void copyStartElement(XMLStreamReader parser, XMLStreamWriter writer) throws Exception {
        int i;
        String namespaceUri = parser.getNamespaceURI();
        String prefix = parser.getPrefix();
        String localName = parser.getLocalName();
        if (namespaceUri != null) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeStartElement(localName);
            } else {
                writer.writeStartElement(prefix, localName, namespaceUri);
            }
        } else {
            writer.writeStartElement(localName);
        }
        for (i = 0; i < parser.getNamespaceCount(); ++i) {
            AtomEntryParser.addNamespace(writer, parser.getNamespacePrefix(i), parser.getNamespaceURI(i));
        }
        AtomEntryParser.addNamespaceIfMissing(writer, prefix, namespaceUri);
        for (i = 0; i < parser.getAttributeCount(); ++i) {
            String attrNamespaceUri = parser.getAttributeNamespace(i);
            String attrPrefix = parser.getAttributePrefix(i);
            String attrName = parser.getAttributeLocalName(i);
            String attrValue = parser.getAttributeValue(i);
            if (attrNamespaceUri == null || attrNamespaceUri.trim().length() == 0) {
                writer.writeAttribute(attrName, attrValue);
                continue;
            }
            if (attrPrefix == null || attrPrefix.trim().length() == 0) {
                writer.writeAttribute(attrNamespaceUri, attrName, attrValue);
                continue;
            }
            AtomEntryParser.addNamespaceIfMissing(writer, attrPrefix, attrNamespaceUri);
            writer.writeAttribute(attrPrefix, attrNamespaceUri, attrName, attrValue);
        }
    }

    private static void addNamespaceIfMissing(XMLStreamWriter writer, String prefix, String namespaceUri) throws Exception {
        Iterator<String> iter;
        if (namespaceUri == null || namespaceUri.trim().length() == 0) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        if ((iter = writer.getNamespaceContext().getPrefixes(namespaceUri)) == null) {
            return;
        }
        while (iter.hasNext()) {
            String p = iter.next();
            if (p == null || !p.equals(prefix)) continue;
            return;
        }
        AtomEntryParser.addNamespace(writer, prefix, namespaceUri);
    }

    private static void addNamespace(XMLStreamWriter writer, String prefix, String namespaceUri) throws Exception {
        if (prefix == null || prefix.trim().length() == 0) {
            writer.setDefaultNamespace(namespaceUri);
            writer.writeDefaultNamespace(namespaceUri);
        } else {
            writer.setPrefix(prefix, namespaceUri);
            writer.writeNamespace(prefix, namespaceUri);
        }
    }

    private static void skip(XMLStreamReader parser) throws Exception {
        int level = 1;
        while (AtomEntryParser.next(parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                ++level;
                continue;
            }
            if (event != 2 || --level != 0) continue;
            break;
        }
        AtomEntryParser.next(parser);
    }

    private static boolean next(XMLStreamReader parser) throws Exception {
        if (parser.hasNext()) {
            try {
                parser.next();
            }
            catch (XMLStreamException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    private static class ThresholdOutputStream
    extends OutputStream {
        private static final int MAX_GROW = 0xA00000;
        private static final int THRESHOLD = 0x400000;
        private byte[] buf = null;
        private int bufSize = 0;
        private long size;
        private File tmpFile;
        private OutputStream tmpStream;

        public ThresholdOutputStream() {
            this(65536);
        }

        public ThresholdOutputStream(int initSize) {
            if (initSize < 0) {
                throw new IllegalArgumentException("Negative initial size: " + initSize);
            }
            this.buf = new byte[initSize];
        }

        private void expand(int nextBufferSize) throws IOException {
            if (this.bufSize + nextBufferSize <= this.buf.length) {
                return;
            }
            if (this.bufSize + nextBufferSize > 0x400000) {
                if (this.tmpStream == null) {
                    this.tmpFile = File.createTempFile("opencmis", null);
                    this.tmpStream = new FileOutputStream(this.tmpFile);
                }
                this.tmpStream.write(this.buf, 0, this.bufSize);
                if (this.buf.length != 0x400000) {
                    this.buf = new byte[0x400000];
                }
                this.bufSize = 0;
                return;
            }
            int newSize = (this.bufSize + nextBufferSize) * 2 < 0xA00000 ? (this.bufSize + nextBufferSize) * 2 : this.buf.length + nextBufferSize + 0xA00000;
            byte[] newbuf = new byte[newSize];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufSize);
            this.buf = newbuf;
        }

        public long getSize() {
            return this.size;
        }

        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        public void write(byte[] buffer, int offset, int len) throws IOException {
            if (len == 0) {
                return;
            }
            this.expand(len);
            System.arraycopy(buffer, offset, this.buf, this.bufSize, len);
            this.bufSize += len;
            this.size += (long)len;
        }

        public void write(int oneByte) throws IOException {
            if (this.bufSize == this.buf.length) {
                this.expand(1);
            }
            this.buf[this.bufSize++] = (byte)oneByte;
            ++this.size;
        }

        public void flush() throws IOException {
            if (this.tmpStream != null) {
                if (this.bufSize > 0) {
                    this.tmpStream.write(this.buf, 0, this.bufSize);
                    this.bufSize = 0;
                }
                this.tmpStream.flush();
            }
        }

        public void close() throws IOException {
            this.flush();
            if (this.tmpStream != null) {
                this.tmpStream.close();
            }
        }

        public InputStream getInputStream() throws Exception {
            if (this.tmpStream != null) {
                this.close();
                this.buf = null;
                return new InternalTempFileInputStream();
            }
            return new InternalBufferInputStream();
        }

        static /* synthetic */ byte[] access$202(ThresholdOutputStream x0, byte[] x1) {
            x0.buf = x1;
            return x1;
        }

        private class InternalTempFileInputStream
        extends FilterInputStream {
            private boolean isDeleted;

            public InternalTempFileInputStream() throws FileNotFoundException {
                super(new BufferedInputStream(new FileInputStream(ThresholdOutputStream.this.tmpFile), 0x400000));
                this.isDeleted = false;
            }

            public boolean markSupported() {
                return false;
            }

            public int read() throws IOException {
                int b = super.read();
                if (b == -1 && !this.isDeleted) {
                    super.close();
                    this.isDeleted = ThresholdOutputStream.this.tmpFile.delete();
                }
                return b;
            }

            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int n = super.read(b, off, len);
                if (n == -1 && !this.isDeleted) {
                    super.close();
                    this.isDeleted = ThresholdOutputStream.this.tmpFile.delete();
                }
                return n;
            }

            public void close() throws IOException {
                if (!this.isDeleted) {
                    super.close();
                    this.isDeleted = ThresholdOutputStream.this.tmpFile.delete();
                }
            }
        }

        private class InternalBufferInputStream
        extends InputStream {
            private int pos = 0;

            private InternalBufferInputStream() {
            }

            public boolean markSupported() {
                return false;
            }

            public int available() {
                return ThresholdOutputStream.this.bufSize - this.pos;
            }

            public int read() {
                return this.pos < ThresholdOutputStream.this.bufSize && ThresholdOutputStream.this.buf != null ? ThresholdOutputStream.this.buf[this.pos++] & 0xFF : -1;
            }

            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            public int read(byte[] b, int off, int len) {
                if (this.pos >= ThresholdOutputStream.this.bufSize || ThresholdOutputStream.this.buf == null) {
                    return -1;
                }
                if (this.pos + len > ThresholdOutputStream.this.bufSize) {
                    len = ThresholdOutputStream.this.bufSize - this.pos;
                }
                System.arraycopy(ThresholdOutputStream.this.buf, this.pos, b, off, len);
                this.pos += len;
                return len;
            }

            public long skip(long n) {
                if ((long)this.pos + n > (long)ThresholdOutputStream.this.bufSize) {
                    n = ThresholdOutputStream.this.bufSize - this.pos;
                }
                if (n < 0L) {
                    return 0L;
                }
                this.pos = (int)((long)this.pos + n);
                return n;
            }

            public void close() throws IOException {
                ThresholdOutputStream.access$202(ThresholdOutputStream.this, null);
            }
        }
    }
}

