/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.cloud;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.StaticServiceDiscovery;
import org.apache.camel.spring.boot.cloud.CamelCloudAutoConfiguration;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.apache.camel.spring.boot.cloud.CamelCloudServiceDiscovery;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelCloudAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelCloudConfigurationProperties.class})
@Conditional(value={Condition.class})
public class CamelCloudServiceDiscoveryAutoConfiguration
implements BeanFactoryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelCloudServiceDiscoveryAutoConfiguration.class);
    private BeanFactory beanFactory;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private CamelCloudConfigurationProperties configurationProperties;

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.beanFactory = factory;
    }

    @Lazy
    @Bean(name={"static-service-discovery"})
    public ServiceDiscovery staticServiceDiscovery() {
        return this.createStaticServiceDiscovery(this.configurationProperties.getServiceDiscovery());
    }

    @Lazy
    @Bean(name={"service-discovery"})
    public CamelCloudServiceDiscovery serviceDiscovery(List<ServiceDiscovery> serviceDiscoveryList) throws NoTypeConversionAvailableException {
        return new CamelCloudServiceDiscovery(serviceDiscoveryList);
    }

    @PostConstruct
    public void addServiceDiscoveryConfigurations() {
        if (!(this.beanFactory instanceof ConfigurableBeanFactory)) {
            LOGGER.warn("BeanFactory is not of type ConfigurableBeanFactory");
            return;
        }
        ConfigurableBeanFactory factory = (ConfigurableBeanFactory)this.beanFactory;
        this.configurationProperties.getServiceDiscovery().getConfigurations().entrySet().stream().forEach(entry -> this.registerBean(factory, (String)entry.getKey(), (CamelCloudConfigurationProperties.ServiceDiscoveryConfiguration)entry.getValue()));
    }

    private void registerBean(ConfigurableBeanFactory factory, String name, CamelCloudConfigurationProperties.ServiceDiscoveryConfiguration configuration) {
        factory.registerSingleton(name, (Object)this.createStaticServiceDiscovery(configuration));
    }

    private ServiceDiscovery createStaticServiceDiscovery(CamelCloudConfigurationProperties.ServiceDiscoveryConfiguration configuration) {
        StaticServiceDiscovery staticServiceDiscovery = new StaticServiceDiscovery();
        Map<String, List<String>> services = configuration.getServices();
        for (Map.Entry<String, List<String>> entry : services.entrySet()) {
            staticServiceDiscovery.addServers(entry.getKey(), entry.getValue());
        }
        configuration.getServiceDefinitions().entrySet().stream().flatMap(serviceDefinitionEntry -> ((List)serviceDefinitionEntry.getValue()).stream().map(serviceDefinitionConf -> DefaultServiceDefinition.builder().withName((String)serviceDefinitionEntry.getKey()).withId(serviceDefinitionConf.getId()).withHost(serviceDefinitionConf.getHost()).withPort(Integer.valueOf(serviceDefinitionConf.getPort())).withMeta(serviceDefinitionConf.getMetadata()).build())).forEach(arg_0 -> ((StaticServiceDiscovery)staticServiceDiscovery).addServer(arg_0));
        return staticServiceDiscovery;
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.cloud", "camel.cloud.service-discovery");
        }
    }
}

